#!/bin/bash
set -e

function create_default_conf {
    echo "%tag! +_set:do-not-use-snmp
%if! tag _set:do-not-use-snmp? -- skip 2
%tag! -_set:do-not-use-snmp
%^r:ipmi-boot! cdrom
%^r:vlan-switch! 542
%^r:ipmi-boot! pxe
%^discovery --smart-relax
%^setup"

    for i in lib/* ; do
        echo
        cat $i
        echo
    done
    footer
    echo "%r:ipmi-boot! disk"
}

function create_4walle_conf {
    echo "%^r:ipmi-boot! pxe
%^discovery --smart-relax
%^setup"
    for i in lib/* ; do
        echo
        cat $i
        echo
    done
    echo "%r:ipmi-boot! disk"
}

function footer {
        echo "%r:vlan-switch! 648
1358 (.*dev|test|jenkins).*
650 (.advq|uspokazgen|usgen-test-load).*"
}

function push_to_eine {
    PROFILE_NAME=$1
    PROFILE=$2
    eine -s eine.yandex-team.ru profile add $PROFILE_NAME rules $PROFILE
    echo "Profile direct created on $EINE_SERVER"
}



tmpfile=$(mktemp -t eineXXXX)
tmpfile_walle=$(mktemp -t eineXXXX)
create_default_conf > $tmpfile
create_4walle_conf > $tmpfile_walle
push_to_eine direct $tmpfile
push_to_eine direct-wall-e $tmpfile_walle
rm $tmpfile
rm $tmpfile_walle
