#!/usr/bin/perl

# Этот код ещё в разработке и не готов к регулярному использованию.

=head1 NAME

    create-mongo-indexes.pl -- шардировать коллекции и создать индексы в mongo

=head1 SYNOPSIS

    create-mongo-indexes.pl --file moddb.json --host yukaba-directmod.haze.yandex.net --port 27017 --user moddb --password ...

=head1 DESCRIPTION

    Параметры:
        --host, --port, --user, --password
            параметры подключения к монге, в которой собираемся создавать индексы
        --file <path>
            путь к файлу, содержащему список индексов
            для модерации генерируется скриптом protected/maintenance/get-mongo-schema.pl в транке Модерации, описание формата можно посмотреть там же
            если не указан, читает из стандартного ввода

=cut

use strict;
use warnings;

use utf8;

use open qw/:std :encoding(UTF-8)/;

use Data::Dumper;
use Getopt::Long;
use MongoDB;
use JSON;
use Try::Tiny;

use Yandex::HashUtils qw/hash_cut/;

run() unless caller();

sub run {
    my $opt = parse_options();
    my $fh;
    if ($opt->{file}) {
        open $fh, '<:encoding(UTF-8)', $opt->{file} or die "can't open $opt->{file}: $!";
    } else {
        $fh = \*STDIN;
    }
    my $mongo = MongoDB::MongoClient->new(%{ hash_cut $opt, qw/host port username password/ });
    my $json = do { local $/ = undef; <$fh> };
    close $fh;
    my $h = from_json($json);
    my $db_name = $h->{db};
    my $db = $mongo->get_database($db_name);
    my $shard_indexes = $h->{shard_indexes} // {};
    my $indexes = $h->{indexes} // {};
    my $coll_name;
    my $admin_db = $mongo->get_database("admin");
    for $coll_name (sort keys %$indexes) {
        print $coll_name . "\n";
        my $coll = $db->get_collection($coll_name);
        for my $idx (@{$indexes->{$coll_name}}) {
            next if @{ $idx->{key} } == 2 && $idx->{key}->[1] eq 'hashed';  # это индексы, которые создадутся при шардировании
            print $idx->{name} . ' ';
            my %idx_opts = %$idx;
            my $key = delete $idx_opts{key};
            try {
                my $res = $coll->ensure_index($key, \%idx_opts);
                print ref $res eq 'HASH' && $res->{ok} ? "ok\n" : Dumper($res);
            } catch { print Dumper($_) };
        }
    }
    for $coll_name (sort keys %$shard_indexes) {
        print $coll_name . ' ';
        try {
            my $res = $admin_db->run_command({shardCollection => "$db_name.$coll_name", key => $shard_indexes->{$coll_name}->{shard_key}});
            print ref $res eq 'HASH' && $res->{ok} ? "ok\n" : Dumper($res);
        } catch { print Dumper($_) };
    }
}

sub parse_options {
    my %O = (
        host => 'localhost',
        port => 27017,
    );
    GetOptions(
        'host=s' => \$O{host},
        'port=s' => \$O{port},
        'u|user=s' => \$O{username},
        'password=s' => \$O{password},
        'f|file=s' => \$O{file},
        'help' => sub { system("podselect -section NAME -section SYNOPSIS -section DESCRIPTION $0 | pod2text-utf8 >&2"); exit 0 },
    ) || die "can't parse options, stop\n";
    die "user is not specified\n" unless $O{username};
    die "password for $O{username} is not specified\n" unless $O{password};
    return \%O;
}

1;
