begin;

-- MySQL dump 10.13  Distrib 5.5.35, for debian-linux-gnu (x86_64)
--
-- Host: moddb01e.yandex.ru    Database: moddb
-- ------------------------------------------------------
-- Server version	5.5.36-34.2-648.precise-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

drop database if exists modlog;
drop database if exists moddb;

CREATE DATABASE `modlog` /*!40100 DEFAULT CHARACTER SET utf8 */;
CREATE DATABASE `moddb` /*!40100 DEFAULT CHARACTER SET utf8 */;

use moddb;

--
-- Table structure for table `LDAPusers`
--

DROP TABLE IF EXISTS `LDAPusers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `LDAPusers` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `login` varchar(32) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `name` varchar(32) DEFAULT NULL,
  `admin` enum('Y','N') NOT NULL DEFAULT 'N',
  `list_options` varchar(255) DEFAULT '',
  `hidden` enum('Yes','No') NOT NULL DEFAULT 'No',
  `lang` varchar(2) DEFAULT 'ru',
  `role_id` int(11) DEFAULT NULL,
  `work_phone` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID` (`ID`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB AUTO_INCREMENT=9608188 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `angel_bayes_wordstat`
--

DROP TABLE IF EXISTS `angel_bayes_wordstat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `angel_bayes_wordstat` (
  `word` varchar(128) NOT NULL,
  `spam` int(11) NOT NULL,
  `ham` int(11) NOT NULL,
  PRIMARY KEY (`word`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `angel_bayes_wordstat_by_1word`
--

DROP TABLE IF EXISTS `angel_bayes_wordstat_by_1word`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `angel_bayes_wordstat_by_1word` (
  `word` varchar(128) NOT NULL,
  `spam` int(11) NOT NULL,
  `ham` int(11) NOT NULL,
  PRIMARY KEY (`word`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `angel_filters_groups`
--

DROP TABLE IF EXISTS `angel_filters_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `angel_filters_groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `am_alias` varchar(32) DEFAULT NULL,
  `filter` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `am_alias` (`am_alias`),
  KEY `filter` (`filter`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `angel_filters_params`
--

DROP TABLE IF EXISTS `angel_filters_params`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `angel_filters_params` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filter` varchar(255) NOT NULL,
  `data` varchar(1024) NOT NULL,
  `enabled` char(1) NOT NULL DEFAULT '1',
  `tag` varchar(255) NOT NULL DEFAULT 'default',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `part` enum('banner','phrases','contactinfo','sitelinks','full','banner_sitelinks') DEFAULT 'full',
  `moderator` int(11) DEFAULT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `serialized` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `filter` (`filter`),
  KEY `data` (`data`(255))
) ENGINE=InnoDB AUTO_INCREMENT=21590 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `angel_filters_params_deleted`
--

DROP TABLE IF EXISTS `angel_filters_params_deleted`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `angel_filters_params_deleted` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filter` varchar(255) NOT NULL,
  `data` varchar(1024) NOT NULL,
  `enabled` char(1) NOT NULL DEFAULT '1',
  `tag` varchar(255) NOT NULL DEFAULT 'default',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `part` enum('banner','phrases','contactinfo','sitelinks','full') NOT NULL DEFAULT 'full',
  `moderator` int(11) DEFAULT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `serialized` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `filter` (`filter`),
  KEY `data` (`data`(255))
) ENGINE=InnoDB AUTO_INCREMENT=21586 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `angel_reasons`
--

DROP TABLE IF EXISTS `angel_reasons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `angel_reasons` (
  `reason_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `banner_id` int(11) unsigned NOT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `filter` varchar(255) NOT NULL,
  `reasons` text NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`reason_id`),
  KEY `banner_id` (`banner_id`),
  KEY `uid` (`uid`),
  KEY `timecreated` (`timecreated`)
) ENGINE=InnoDB AUTO_INCREMENT=12912201 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `angel_top_sites`
--

DROP TABLE IF EXISTS `angel_top_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `angel_top_sites` (
  `position` int(10) unsigned NOT NULL,
  `domain` varchar(128) NOT NULL,
  `reverse_domain` varchar(128) NOT NULL,
  PRIMARY KEY (`position`),
  KEY `domain` (`domain`),
  KEY `reverse_domain` (`reverse_domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `backup_LDAPusers`
--

DROP TABLE IF EXISTS `backup_LDAPusers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_LDAPusers` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `login` varchar(16) DEFAULT NULL,
  `password` varchar(32) DEFAULT NULL,
  `name` varchar(32) DEFAULT NULL,
  `admin` enum('Y','N') NOT NULL DEFAULT 'N',
  `list_options` varchar(255) DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `ID` (`ID`),
  UNIQUE KEY `login` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `banner_categories_flags`
--

DROP TABLE IF EXISTS `banner_categories_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banner_categories_flags` (
  `bid` bigint(20) NOT NULL DEFAULT '0',
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `choosed` varchar(225) DEFAULT NULL,
  `unchecked` varchar(255) DEFAULT NULL,
  `flags` varchar(255) DEFAULT '',
  PRIMARY KEY (`bid`),
  KEY `logtime` (`logtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `banner_categories_flags_old`
--

DROP TABLE IF EXISTS `banner_categories_flags_old`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banner_categories_flags_old` (
  `bid` int(11) NOT NULL DEFAULT '0',
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `choosed` varchar(225) DEFAULT NULL,
  `unchecked` varchar(255) DEFAULT NULL,
  `flags` varchar(255) DEFAULT '',
  PRIMARY KEY (`bid`),
  KEY `logtime` (`logtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `banner_lang`
--

DROP TABLE IF EXISTS `banner_lang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banner_lang` (
  `cid` int(11) NOT NULL,
  `bid` int(11) NOT NULL,
  `lang` char(10) NOT NULL,
  `country` char(20) NOT NULL,
  PRIMARY KEY (`bid`),
  KEY `cid` (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `camp_send`
--

DROP TABLE IF EXISTS `camp_send`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `camp_send` (
  `cid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `cid` (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `campaigns_auto_moderate`
--

DROP TABLE IF EXISTS `campaigns_auto_moderate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `campaigns_auto_moderate` (
  `cid` int(11) NOT NULL,
  `statusPostModerate` enum('Yes','No') DEFAULT NULL,
  `timeProcessed` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `details` text,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogia_flags`
--

DROP TABLE IF EXISTS `catalogia_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `catalogia_flags` (
  `bid` bigint(20) NOT NULL,
  `flags` text,
  `rubrics` int(11) DEFAULT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `rubrics_list` text,
  PRIMARY KEY (`bid`),
  KEY `timecreated` (`timecreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `checksum`
--

DROP TABLE IF EXISTS `checksum`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checksum` (
  `db` varchar(64) NOT NULL,
  `tbl` varchar(64) NOT NULL,
  `chunk` int(11) NOT NULL,
  `boundaries` varchar(128) NOT NULL,
  `this_crc` char(40) NOT NULL,
  `this_cnt` int(11) NOT NULL,
  `master_crc` char(40) DEFAULT NULL,
  `master_cnt` int(11) DEFAULT NULL,
  `ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`db`,`tbl`,`chunk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `checksum_result`
--

DROP TABLE IF EXISTS `checksum_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `checksum_result` (
  `name` varchar(32) NOT NULL,
  `value` varchar(256) NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cv_image_classify`
--

DROP TABLE IF EXISTS `cv_image_classify`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cv_image_classify` (
  `image_hash_p1` bigint(20) unsigned NOT NULL DEFAULT '0',
  `image_hash_p2` bigint(20) unsigned NOT NULL DEFAULT '0',
  `data` text,
  `user_data` text,
  `timechanged` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `image_hash` (`image_hash_p1`,`image_hash_p2`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dbscheme_test_books`
--

DROP TABLE IF EXISTS `dbscheme_test_books`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dbscheme_test_books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `author` int(11) DEFAULT NULL,
  `editor` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `rtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dbscheme_test_tbl1`
--

DROP TABLE IF EXISTS `dbscheme_test_tbl1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dbscheme_test_tbl1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `string_key` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dbscheme_test_tbl2`
--

DROP TABLE IF EXISTS `dbscheme_test_tbl2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dbscheme_test_tbl2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key1` int(11) NOT NULL,
  `key2` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `dbscheme_test_tbl3`
--

DROP TABLE IF EXISTS `dbscheme_test_tbl3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dbscheme_test_tbl3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key1` int(11) NOT NULL,
  `key2` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `direct_cmd_queue`
--

DROP TABLE IF EXISTS `direct_cmd_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `direct_cmd_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) unsigned NOT NULL,
  `cmd` varchar(32) NOT NULL,
  `data` mediumtext NOT NULL,
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `fail` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18078235 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `geo_regions`
--

DROP TABLE IF EXISTS `geo_regions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `geo_regions` (
  `geo_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `ename` varchar(255) NOT NULL DEFAULT '',
  `ua_name` varchar(255) NOT NULL DEFAULT '',
  `parents` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`geo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `hrefs_params`
--

DROP TABLE IF EXISTS `hrefs_params`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hrefs_params` (
  `phrase_id` bigint(20) unsigned NOT NULL,
  `bid` int(11) NOT NULL,
  `pid` int(11) NOT NULL,
  `param1` varchar(255) DEFAULT NULL,
  `param2` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`phrase_id`),
  KEY `pid` (`pid`),
  KEY `bid` (`bid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `licensed_rubrics`
--

DROP TABLE IF EXISTS `licensed_rubrics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `licensed_rubrics` (
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `timecreate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `licensed_rubrics_add`
--

DROP TABLE IF EXISTS `licensed_rubrics_add`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `licensed_rubrics_add` (
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `timecreate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `magic_cmd_queue`
--

DROP TABLE IF EXISTS `magic_cmd_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magic_cmd_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cmd` varchar(32) NOT NULL,
  `data` mediumtext NOT NULL,
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13371 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_banners`
--

DROP TABLE IF EXISTS `mod_banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bid` int(11) NOT NULL,
  `pid` int(11) NOT NULL DEFAULT '0',
  `timecreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `timechanged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusModerate` enum('New','Yes','No','Old','Wait','None') NOT NULL DEFAULT 'New',
  `statusProcessed` enum('Yes','No','NotRequired') NOT NULL DEFAULT 'No',
  `statusPostModerate` enum('Yes','No','Auto','Rejected') NOT NULL DEFAULT 'No',
  `errors` text NOT NULL,
  `statusSync` enum('New','Ready','Sent','Sending') NOT NULL DEFAULT 'New',
  `moderator` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  `data` blob,
  PRIMARY KEY (`id`),
  KEY `statusSync` (`statusSync`),
  KEY `cid` (`cid`),
  KEY `bid` (`bid`),
  KEY `i_mod_banners_time_created` (`timecreated`),
  KEY `i_mod_banners_time_changed` (`timechanged`),
  KEY `i_mod_banners_moderator` (`moderator`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=638074525 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_banners_export_versions`
--

DROP TABLE IF EXISTS `mod_banners_export_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_banners_export_versions` (
  `object_id` bigint(11) unsigned NOT NULL DEFAULT '0',
  `bid` bigint(11) unsigned NOT NULL DEFAULT '0',
  `version` varchar(36) DEFAULT NULL,
  `counter` smallint(6) NOT NULL DEFAULT '0',
  UNIQUE KEY `bid` (`bid`),
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_banners_sequence_refs`
--

DROP TABLE IF EXISTS `mod_banners_sequence_refs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_banners_sequence_refs` (
  `bid` int(11) unsigned NOT NULL,
  `cid` int(11) unsigned NOT NULL,
  `pid` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `next` int(11) unsigned DEFAULT NULL,
  UNIQUE KEY `uniq_id` (`object_id`),
  KEY `object_id` (`object_id`),
  KEY `next` (`next`),
  KEY `bid` (`bid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_campaigns`
--

DROP TABLE IF EXISTS `mod_campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_campaigns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` enum('text','mcb','socdem','geo','api','mobile_content') NOT NULL DEFAULT 'text',
  `timecreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `timechanged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusPostModerate` enum('Yes','No','Auto','Rejected') NOT NULL DEFAULT 'No',
  `statusModerate` enum('New','Yes','No','Old','Wait','None') NOT NULL DEFAULT 'New',
  `statusProcessed` enum('Yes','No','NotRequired') NOT NULL DEFAULT 'No',
  `data` blob,
  `errors` text NOT NULL,
  `statusSync` enum('New','Ready','Sent','Sending') NOT NULL DEFAULT 'New',
  `moderator` int(11) NOT NULL DEFAULT '0',
  `statusServicing` enum('Yes','No') DEFAULT NULL,
  `clientID` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cid` (`cid`),
  KEY `statusSync` (`statusSync`),
  KEY `timeChanged` (`timechanged`),
  KEY `i_camp_uid` (`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=52740178 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_complaints`
--

DROP TABLE IF EXISTS `mod_complaints`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_complaints` (
  `id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(11) NOT NULL DEFAULT '',
  `filter` varchar(255) DEFAULT NULL,
  `reason_id` int(11) NOT NULL DEFAULT '0',
  `banner_id` int(11) unsigned NOT NULL DEFAULT '0',
  `reasons` text,
  UNIQUE KEY `complaint` (`id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_contactinfo`
--

DROP TABLE IF EXISTS `mod_contactinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_contactinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kid` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  `timecreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `timechanged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusModerate` enum('New','Yes','No','Old','Wait','None') NOT NULL DEFAULT 'New',
  `statusProcessed` enum('Yes','No','NotRequired') NOT NULL DEFAULT 'No',
  `statusPostModerate` enum('Yes','No','Auto','Rejected') NOT NULL DEFAULT 'No',
  `errors` text NOT NULL,
  `statusSync` enum('New','Ready','Sent','Sending') NOT NULL DEFAULT 'New',
  `moderator` int(11) NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `data` blob,
  PRIMARY KEY (`id`),
  KEY `statusSync` (`statusSync`),
  KEY `bid` (`bid`),
  KEY `cid` (`cid`),
  KEY `kids` (`kid`),
  KEY `i_mod_contactinfo_time_created` (`timecreated`),
  KEY `i_mod_contactinfo_time_changed` (`timechanged`),
  KEY `i_mod_contactinfo_moderator` (`moderator`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=179042335 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_contactinfo_export_versions`
--

DROP TABLE IF EXISTS `mod_contactinfo_export_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_contactinfo_export_versions` (
  `object_id` int(11) unsigned NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `version` varchar(36) DEFAULT NULL,
  `counter` smallint(6) NOT NULL DEFAULT '0',
  UNIQUE KEY `bid` (`bid`),
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_contactinfo_sequence_refs`
--

DROP TABLE IF EXISTS `mod_contactinfo_sequence_refs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_contactinfo_sequence_refs` (
  `bid` int(11) unsigned NOT NULL,
  `cid` int(11) unsigned NOT NULL,
  `kid` int(11) unsigned NOT NULL,
  `pid` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `next` int(11) unsigned DEFAULT NULL,
  UNIQUE KEY `uniq_id` (`object_id`),
  KEY `bid` (`bid`),
  KEY `object_id` (`object_id`),
  KEY `next` (`next`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_documents`
--

DROP TABLE IF EXISTS `mod_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_documents` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(11) unsigned NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `moderator` int(11) NOT NULL,
  `reverse_domain` varchar(512) NOT NULL DEFAULT '',
  `domain` varchar(512) NOT NULL DEFAULT '',
  `comment` varchar(1024) DEFAULT '',
  `expires` datetime NOT NULL,
  `status` enum('Ready','NotReady') DEFAULT 'Ready',
  `document_type` varchar(96) NOT NULL DEFAULT '',
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `timechanged` datetime NOT NULL,
  `domain_hash` char(32) NOT NULL,
  `clear_phone` varchar(20) DEFAULT NULL,
  `clientID` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_hash` (`domain_hash`,`uid`),
  KEY `reverse_domain` (`reverse_domain`(255)),
  KEY `uid` (`uid`),
  KEY `cid` (`cid`),
  KEY `clear_phone` (`clear_phone`)
) ENGINE=InnoDB AUTO_INCREMENT=1083036 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_documents_flags`
--

DROP TABLE IF EXISTS `mod_documents_flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_documents_flags` (
  `doc_id` int(10) NOT NULL,
  `flag_name` varchar(128) NOT NULL,
  UNIQUE KEY `doc_id` (`doc_id`,`flag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_documents_old`
--

DROP TABLE IF EXISTS `mod_documents_old`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_documents_old` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `moderator` int(11) NOT NULL,
  `reverse_domain` varchar(512) NOT NULL DEFAULT '',
  `domain` varchar(512) NOT NULL DEFAULT '',
  `comment` varchar(1024) DEFAULT '',
  `expires` datetime DEFAULT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `timechanged` datetime NOT NULL,
  `path` varchar(1024) NOT NULL,
  `filename` varchar(512) NOT NULL,
  `status` enum('Wait','Approved') NOT NULL DEFAULT 'Wait',
  PRIMARY KEY (`id`),
  KEY `reverse_domain` (`reverse_domain`(255)),
  KEY `domain` (`domain`(255)),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `cid` (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_domain_history`
--

DROP TABLE IF EXISTS `mod_domain_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_domain_history` (
  `domain` varchar(50) NOT NULL,
  `reasons` varchar(50) DEFAULT NULL,
  `accepted` int(11) DEFAULT NULL,
  `declined` int(11) DEFAULT NULL,
  `reverse_domain` varchar(50) NOT NULL,
  PRIMARY KEY (`domain`),
  KEY `reverse_domain` (`reverse_domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_domain_history_cache`
--

DROP TABLE IF EXISTS `mod_domain_history_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_domain_history_cache` (
  `domain` varchar(50) NOT NULL,
  `reasons` varchar(50) DEFAULT NULL,
  `accepted` int(11) DEFAULT NULL,
  `declined` int(11) DEFAULT NULL,
  `reverse_domain` varchar(50) NOT NULL,
  PRIMARY KEY (`domain`),
  KEY `reverse_domain` (`reverse_domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_domain_spam`
--

DROP TABLE IF EXISTS `mod_domain_spam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_domain_spam` (
  `domain` varchar(50) NOT NULL,
  `class` enum('spam','grey','good') DEFAULT NULL,
  `reg_date` datetime DEFAULT NULL,
  `cy` int(11) DEFAULT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `free_hosting` enum('Yes','No') NOT NULL DEFAULT 'No',
  `cy2` int(11) DEFAULT NULL,
  `yaca` enum('Yes','No') DEFAULT 'No',
  `reason_type` int(11) DEFAULT NULL,
  `LAB` double DEFAULT NULL,
  `mfas` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_edit`
--

DROP TABLE IF EXISTS `mod_edit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_edit` (
  `type` enum('banner','contactinfo') NOT NULL DEFAULT 'banner',
  `id` int(11) NOT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `timeupdated` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `data` text,
  PRIMARY KEY (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_file_list`
--

DROP TABLE IF EXISTS `mod_file_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_file_list` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(128) NOT NULL,
  `category_id` int(10) DEFAULT NULL,
  `path` varchar(1024) NOT NULL,
  `filename` varchar(512) NOT NULL,
  `timechanged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cid` int(11) NOT NULL,
  `clientID` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`file_id`),
  KEY `category` (`category`),
  KEY `category_id` (`category_id`),
  KEY `path` (`path`(255)),
  KEY `mod_file_list_clientID` (`clientID`)
) ENGINE=InnoDB AUTO_INCREMENT=1672534 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_forced_objects`
--

DROP TABLE IF EXISTS `mod_forced_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_forced_objects` (
  `ref_id` int(11) NOT NULL,
  `type` enum('banner','phrases','contactinfo','sitelinks','images') NOT NULL DEFAULT 'banner',
  `is_forced` char(1) NOT NULL,
  PRIMARY KEY (`ref_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_hilight`
--

DROP TABLE IF EXISTS `mod_hilight`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_hilight` (
  `phrase` varchar(255) NOT NULL DEFAULT '',
  `marker` varchar(20) NOT NULL DEFAULT 'red',
  `comment` text,
  `timechanged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `timecreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` enum('text','mcb') NOT NULL DEFAULT 'text',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1534 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_hrefs`
--

DROP TABLE IF EXISTS `mod_hrefs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_hrefs` (
  `banner_id` int(11) NOT NULL,
  `domain` varchar(1024) DEFAULT NULL,
  `href` varchar(4096) DEFAULT NULL,
  `href_md5` char(32) DEFAULT NULL,
  `redirect` varchar(4096) DEFAULT NULL,
  PRIMARY KEY (`banner_id`),
  KEY `href_md5` (`href_md5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_icons`
--

DROP TABLE IF EXISTS `mod_icons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_icons` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `timechanged` datetime NOT NULL,
  `statusModerate` enum('New','Yes','No','Old','Wait','None') NOT NULL DEFAULT 'New',
  `statusProcessed` enum('Yes','No','NotRequired') NOT NULL DEFAULT 'No',
  `statusPostModerate` enum('Yes','No','Auto','Rejected') NOT NULL DEFAULT 'No',
  `errors` text NOT NULL,
  `statusSync` enum('New','Ready','Sent','Sending') NOT NULL DEFAULT 'New',
  `moderator` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `bid` int(11) NOT NULL,
  `pid` int(11) NOT NULL DEFAULT '0',
  `source_ref` char(32) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `bid` (`bid`),
  KEY `cid` (`cid`),
  KEY `timecreated` (`timecreated`),
  KEY `timechanged` (`timechanged`),
  KEY `statusSync` (`statusSync`),
  KEY `moderator` (`moderator`)
) ENGINE=InnoDB AUTO_INCREMENT=19955601 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_icons_classes`
--

DROP TABLE IF EXISTS `mod_icons_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_icons_classes` (
  `class_id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_icons_classified`
--

DROP TABLE IF EXISTS `mod_icons_classified`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_icons_classified` (
  `icon_hash` char(32) DEFAULT NULL,
  `class_id` tinyint(4) NOT NULL DEFAULT '0',
  UNIQUE KEY `icon_class` (`icon_hash`,`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_icons_export_versions`
--

DROP TABLE IF EXISTS `mod_icons_export_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_icons_export_versions` (
  `object_id` int(11) unsigned NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `version` varchar(36) DEFAULT NULL,
  `counter` smallint(6) NOT NULL DEFAULT '0',
  UNIQUE KEY `bid` (`bid`),
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_icons_sequence_refs`
--

DROP TABLE IF EXISTS `mod_icons_sequence_refs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_icons_sequence_refs` (
  `bid` int(11) unsigned NOT NULL,
  `cid` int(11) unsigned NOT NULL,
  `source_ref` char(32) DEFAULT NULL,
  `pid` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `next` int(11) unsigned DEFAULT NULL,
  UNIQUE KEY `uniq_id` (`object_id`),
  KEY `bid` (`bid`),
  KEY `object_id` (`object_id`),
  KEY `next` (`next`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_login_black_list`
--

DROP TABLE IF EXISTS `mod_login_black_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_login_black_list` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `login` varchar(50) NOT NULL DEFAULT '',
  `time_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_media_formats`
--

DROP TABLE IF EXISTS `mod_media_formats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_media_formats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `width` (`width`,`height`)
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_phonelist`
--

DROP TABLE IF EXISTS `mod_phonelist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_phonelist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phone` varchar(25) NOT NULL DEFAULT '',
  `banner_id` int(11) NOT NULL DEFAULT '0',
  `contactinfo_id` int(11) NOT NULL DEFAULT '0',
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `statusModerate` enum('Yes','No') DEFAULT 'No',
  `errors` varchar(255) DEFAULT '',
  `comment` mediumtext,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `statusBlackList` enum('Yes','No') NOT NULL DEFAULT 'No',
  `bid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `phone` (`phone`),
  KEY `i_status_black_list` (`statusBlackList`)
) ENGINE=InnoDB AUTO_INCREMENT=33650001 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_phrases`
--

DROP TABLE IF EXISTS `mod_phrases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_phrases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `timecreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `timechanged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusModerate` enum('New','Yes','No','Old','Wait','None') NOT NULL DEFAULT 'New',
  `statusProcessed` enum('Yes','No','NotRequired') NOT NULL DEFAULT 'No',
  `statusPostModerate` enum('Yes','No','Auto','Rejected') NOT NULL DEFAULT 'No',
  `errors` text NOT NULL,
  `statusSync` enum('New','Ready','Sent','Sending') NOT NULL DEFAULT 'New',
  `moderator` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `data` blob,
  PRIMARY KEY (`id`),
  KEY `statusSync` (`statusSync`),
  KEY `bid` (`bid`),
  KEY `cid` (`cid`),
  KEY `pid` (`pid`),
  KEY `i_mod_phrases_time_created` (`timecreated`),
  KEY `i_mod_phrases_time_changed` (`timechanged`),
  KEY `i_mod_phrases_moderator` (`moderator`)
) ENGINE=InnoDB AUTO_INCREMENT=391970635 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_phrases_export_versions`
--

DROP TABLE IF EXISTS `mod_phrases_export_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_phrases_export_versions` (
  `object_id` int(11) unsigned NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `version` varchar(36) DEFAULT NULL,
  `counter` smallint(6) NOT NULL DEFAULT '0',
  UNIQUE KEY `pid` (`pid`),
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_phrases_sequence_refs`
--

DROP TABLE IF EXISTS `mod_phrases_sequence_refs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_phrases_sequence_refs` (
  `bid` int(11) unsigned NOT NULL,
  `cid` int(11) unsigned NOT NULL,
  `pid` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `next` int(11) unsigned DEFAULT NULL,
  UNIQUE KEY `uniq_id` (`object_id`),
  KEY `object_id` (`object_id`),
  KEY `next` (`next`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_post_plan_to_delete`
--

DROP TABLE IF EXISTS `mod_post_plan_to_delete`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_post_plan_to_delete` (
  `cid` int(11) NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `cibi` (`cid`,`bid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_properties`
--

DROP TABLE IF EXISTS `mod_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_properties` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_reasons`
--

DROP TABLE IF EXISTS `mod_reasons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_reasons` (
  `diag_id` int(4) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `subtype` enum('all','text','geo','mobile_content') DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `diag_type` enum('Ok','Reject','Warn') NOT NULL DEFAULT 'Reject',
  `text_full` text,
  `ban_postmoderate` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `sorting` int(11) DEFAULT '0',
  `visible` enum('Yes','No') NOT NULL DEFAULT 'No',
  `enable` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `num_group` int(11) NOT NULL DEFAULT '0',
  `decline_shows` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `token` varchar(32) DEFAULT NULL,
  `lang` varchar(10) DEFAULT '',
  PRIMARY KEY (`diag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_reported_spam`
--

DROP TABLE IF EXISTS `mod_reported_spam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_reported_spam` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `moderator` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`,`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_rights`
--

DROP TABLE IF EXISTS `mod_rights`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_rights` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `right_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_role` (`right_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1000002988 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_rights_list`
--

DROP TABLE IF EXISTS `mod_rights_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_rights_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '',
  `comment` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_roles_list`
--

DROP TABLE IF EXISTS `mod_roles_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_roles_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_sessions_groupmod`
--

DROP TABLE IF EXISTS `mod_sessions_groupmod`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_sessions_groupmod` (
  `moderator` int(11) unsigned DEFAULT NULL,
  `cid` int(11) unsigned DEFAULT NULL,
  `session_data` blob,
  `timechanged` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `session_id` (`moderator`,`cid`),
  KEY `timechanged` (`timechanged`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_sitelinks_export_versions`
--

DROP TABLE IF EXISTS `mod_sitelinks_export_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_sitelinks_export_versions` (
  `object_id` bigint(11) unsigned NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `version` varchar(36) DEFAULT NULL,
  `counter` smallint(6) NOT NULL DEFAULT '0',
  UNIQUE KEY `bid` (`bid`),
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_sitelinks_sets`
--

DROP TABLE IF EXISTS `mod_sitelinks_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_sitelinks_sets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `set_id` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `timecreated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `timechanged` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusModerate` enum('New','Yes','No','Old') NOT NULL DEFAULT 'New',
  `statusProcessed` enum('Yes','No','NotRequired') NOT NULL DEFAULT 'No',
  `statusPostModerate` enum('Yes','No','Auto','Rejected') NOT NULL DEFAULT 'No',
  `errors` text NOT NULL,
  `statusSync` enum('New','Ready','Sent','Sending') NOT NULL DEFAULT 'New',
  `moderator` int(11) NOT NULL DEFAULT '0',
  `data` blob,
  PRIMARY KEY (`id`),
  KEY `statusSync` (`statusSync`),
  KEY `bid` (`bid`),
  KEY `cid` (`cid`),
  KEY `i_mod_site_links_time_created` (`timecreated`),
  KEY `i_mod_site_links_time_changed` (`timechanged`),
  KEY `i_mod_site_links_moderator` (`moderator`),
  KEY `set_id` (`set_id`)
) ENGINE=InnoDB AUTO_INCREMENT=180127076 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_sitelinks_sets_sequence_refs`
--

DROP TABLE IF EXISTS `mod_sitelinks_sets_sequence_refs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_sitelinks_sets_sequence_refs` (
  `bid` int(11) unsigned NOT NULL,
  `set_id` int(11) unsigned NOT NULL,
  `cid` int(11) unsigned NOT NULL,
  `pid` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `next` int(11) unsigned DEFAULT NULL,
  UNIQUE KEY `uniq_id` (`object_id`),
  KEY `bid` (`bid`),
  KEY `object_id` (`object_id`),
  KEY `next` (`next`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_spam_url`
--

DROP TABLE IF EXISTS `mod_spam_url`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_spam_url` (
  `url_id` char(32) NOT NULL DEFAULT '',
  `url` varchar(2048) NOT NULL DEFAULT '',
  `reason` varchar(255) NOT NULL DEFAULT '',
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`url_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_users`
--

DROP TABLE IF EXISTS `mod_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_users` (
  `uid` bigint(20) unsigned NOT NULL,
  `fio` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `countAccepted` int(11) NOT NULL DEFAULT '0',
  `countDeclined` int(11) NOT NULL DEFAULT '0',
  `declinePostModerate` enum('Yes','No') NOT NULL DEFAULT 'No',
  `reasons` varchar(255) DEFAULT NULL,
  `settings` varchar(255) NOT NULL DEFAULT '',
  `good_direct_user` enum('Yes','No') NOT NULL DEFAULT 'No',
  `time_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `login` varchar(128) DEFAULT '',
  `color` enum('Z','WHITE','BLACK','GRAY') DEFAULT 'Z',
  `changed_by` int(11) DEFAULT NULL,
  `timechanged` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `passport_karma` int(11) NOT NULL DEFAULT '0',
  `api_daily_units` int(11) NOT NULL DEFAULT '0',
  `registration_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `priority` enum('High','Medium','Default') NOT NULL DEFAULT 'Default',
  `discount` decimal(4,2) DEFAULT NULL,
  `countCriticalDeclined` int(11) NOT NULL DEFAULT '0',
  `clientID` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`uid`),
  KEY `login` (`login`),
  KEY `color` (`color`),
  KEY `priority` (`priority`),
  KEY `clientID` (`clientID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_users_units`
--

DROP TABLE IF EXISTS `mod_users_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_users_units` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `units` int(11) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_whitelist`
--

DROP TABLE IF EXISTS `mod_whitelist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_whitelist` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL DEFAULT '',
  `comment` varchar(255) NOT NULL DEFAULT '',
  `expires` datetime DEFAULT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `timechanged` datetime NOT NULL,
  `color` varchar(20) NOT NULL DEFAULT 'red',
  `type` enum('info','license','warning','other') NOT NULL DEFAULT 'other',
  `flags` varchar(20) DEFAULT NULL,
  `reverse_url` varchar(255) NOT NULL,
  `clear_phone` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reverse_url` (`reverse_url`),
  KEY `clear_phone` (`clear_phone`)
) ENGINE=InnoDB AUTO_INCREMENT=69711 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mod_whitelist_abb`
--

DROP TABLE IF EXISTS `mod_whitelist_abb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_whitelist_abb` (
  `phrase` varchar(30) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`phrase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `moderate_log`
--

DROP TABLE IF EXISTS `moderate_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `moderate_log` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `cmd` varchar(25) NOT NULL DEFAULT '',
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `host` varchar(50) DEFAULT '',
  `params` varchar(255) DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ngrams_statistic`
--

DROP TABLE IF EXISTS `ngrams_statistic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ngrams_statistic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `value` varchar(255) NOT NULL,
  `type` enum('Yes','No') NOT NULL,
  `n` tinyint(4) NOT NULL,
  `freq` int(11) NOT NULL DEFAULT '0',
  `suffix_freq` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `value` (`value`,`type`),
  KEY `n` (`n`)
) ENGINE=InnoDB AUTO_INCREMENT=78682 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_banners`
--

DROP TABLE IF EXISTS `queue_banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_banners` (
  `id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_phrases`
--

DROP TABLE IF EXISTS `queue_phrases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_phrases` (
  `id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quick_result`
--

DROP TABLE IF EXISTS `quick_result`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quick_result` (
  `cid` int(10) unsigned NOT NULL,
  `logtime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `result` text,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `records_locks`
--

DROP TABLE IF EXISTS `records_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `records_locks` (
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time_lock` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`cid`),
  KEY `timeLock` (`time_lock`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `records_locks_new`
--

DROP TABLE IF EXISTS `records_locks_new`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `records_locks_new` (
  `table_name` varchar(128) NOT NULL,
  `table_ref` int(11) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `lock_start` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `timeout` int(11) unsigned NOT NULL DEFAULT '60',
  UNIQUE KEY `table_name` (`table_name`,`table_ref`),
  KEY `lock_start` (`lock_start`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `records_marks`
--

DROP TABLE IF EXISTS `records_marks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `records_marks` (
  `table_name` varchar(128) NOT NULL,
  `table_ref` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `mark_data` varchar(256) NOT NULL DEFAULT '',
  PRIMARY KEY (`table_name`,`table_ref`,`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task_queue`
--

DROP TABLE IF EXISTS `task_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tq_create_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `tq_recipient` varchar(45) NOT NULL,
  `tq_status` enum('New','Processing','Processed') NOT NULL DEFAULT 'New',
  `tq_request` blob,
  `tq_response` blob,
  PRIMARY KEY (`id`),
  KEY `itq_recipient` (`tq_recipient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ya_focus_page`
--

DROP TABLE IF EXISTS `ya_focus_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ya_focus_page` (
  `md5` char(32) CHARACTER SET latin1 NOT NULL,
  `rubrics` text,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`md5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ya_focus_page_process`
--

DROP TABLE IF EXISTS `ya_focus_page_process`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ya_focus_page_process` (
  `mbid` bigint(11) unsigned NOT NULL,
  `domain` varchar(255) NOT NULL DEFAULT '',
  `href` varchar(4096) NOT NULL,
  `md5` char(32) CHARACTER SET latin1 NOT NULL,
  `task_id` varchar(64) NOT NULL DEFAULT '',
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`mbid`),
  KEY `md5` (`md5`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ya_site_rubrics`
--

DROP TABLE IF EXISTS `ya_site_rubrics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ya_site_rubrics` (
  `domain` varchar(255) NOT NULL DEFAULT '',
  `rubrics` text,
  `timecreated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2016-05-11 15:27:49

commit;
