#! /bin/bash

echo "Start deploy for machine $1"

echo "Try to find yav key"
TOKENS_DIR="/etc/direct-tokens"
YAV_KEY_FILE="$TOKENS_DIR/ssh-rsa_robot-direct-yav-np"

ssh "$1" "ls $YAV_KEY_FILE" &>/dev/null
rc=$?
if [[ $rc != 0 ]]
then 
    echo 'No key found. What host use to get the key?'
    read donor
fi

if [[ $donor != "" ]]
then
    ssh "$1" "mkdir -p $TOKENS_DIR"
    scp -3 "$donor:$YAV_KEY_FILE" "$1:$YAV_KEY_FILE"
fi

echo "Add machine to consul"
cd direct-consul
./consul-client-for-ppctest.sh "$1"

echo "Install mysql packages and environments"
ssh "$1" 'apt-get install yandex-du-mysql-backup-mds yandex-du-sync-db-conf-direct yandex-du-monitoring-complects'
cd ../direct-ts-mysql-init
ansible-playbook direct-ts-mysql.1.init.playbook.yml -l "$1" -t "$2"

echo "restart consul tools"
ssh "$1" 'sv restart consul-agent; pkill -9 consul-template;'

echo "Delete audit files"
ssh "$1" 'find /etc/mysql -name "audit.cnf" -delete'

ssh "$1" "
for i in $(ls -d /var/log/mysql.*)
do
    touch $i/mysql.err
done
"

ssh "$1" "chown -R mysql /var/log/mysql*;chown -R mysql:mysql /opt/mysql.ppcdata*"

echo "Applying grants through 120 sec"; sleep 120 #sleep for consul-template :)
#ssh "$1" "for i in {1..21}; do /usr/local/bin/sync-db-prepare-direct-grants.pl ppcdata"$i"; done"
#ssh "$1" "for i in ppclog ppcmonitor sandbox ; do /usr/local/bin/sync-db-prepare-direct-grants.pl "$i"; done"

ssh "$1" "/usr/local/bin/sync-db-prepare-direct-grants.pl $2"
