package Executer::Command::ConfigSet;

use strict;
use warnings;

use Executer;

use base qw(Executer::Command);

sub cmd {
    my ($self, $name, @vals) = @_;
    
    if (!defined $name) {
        return out->print_error("name not defined");
    }

    if (!@vals) {
        out->print_success("config->{$name} = ".(defined executer->config->{$name} ? "'".executer->config->{$name}."'" : 'undef'));
        return;
    }
    
    my $val = join ' ', @vals;
    if ($val =~ /^\$(.*)/) {
        $val = $ENV{$1};
    } elsif ($val =~ /^`(.*)`$/) {
        $val = `$1`;
        $val =~ s/\s+$//;
    }

    out->print_success("Set config->{$name} = ".(defined $val ? "'$val'" : 'undef'));
    return executer->config->{$name} = $val;
}

sub usage {
    return '<name> [<value>] ...';
}

sub help {
    return qq!Sets a value for config key.
Value may be string, \$ENV_VAR or `shell command`!;
}

1;

