#!/bin/sh

export LC_ALL=C
perl -MAptPkg::Config -e '$AptPkg::Config::_config->system->Lock' 2>&1 | grep -q '^dpkg was interrupted'
if [ "$?" -eq 0 ]
then
    date
    # создаём новую пустую директорию под updates заранее, чтобы понять, можно ли это вообще сделать
    new_updates_dir=$(cd /var/lib/dpkg && mktemp -d updates.new.XXXX)

    if [ -n "$new_updates_dir" -a -d "/var/lib/dpkg/$new_updates_dir" ]; then
        chmod u=rwx,go=rx "/var/lib/dpkg/$new_updates_dir"
        rm -rfv /var/lib/dpkg/updates.bak
        mv -v /var/lib/dpkg/updates /var/lib/dpkg/updates.bak
        mv -v "/var/lib/dpkg/$new_updates_dir" /var/lib/dpkg/updates
    else
        echo "could not create new dir, exiting"
        exit 1
    fi
fi
