#!/usr/bin/env perl

=head1 DESCRIPTION

./prepare-grafana-dashboard.pl dashboards/api-timings.json >requests/$$name-AsIs.json

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;

use Clone qw(clone);
use JSON;
use Path::Tiny;


run() unless caller();

sub run
{
    my $request_tmpl = decode_json(path("$Bin/tmpl/grafana-request-create-dashboard.json")->slurp);
    my $dashboard_raw = decode_json(path($ARGV[0])->slurp);
    my $dashboard = clone($dashboard_raw->{dashboard});
    push @{$dashboard->{tags}}, "auto" unless grep { $_ eq "auto" }  @{$dashboard->{tags}};
    my $request = clone($request_tmpl);
    $request->{dashboard} = $dashboard;
    print to_json($request, { canonical => 1, pretty => 1 } );
}

