#!/usr/bin/python
# -*- coding: utf8 -*-

import urllib
import urllib2
import json
import time

'''
Скрипт расчитывает тайминги интерфейса и API для аудиторов.
Графики живут на дашбоарде http://ppcgraphite.yandex.ru/dashboard/#Direct_SLA.
'''

chUrl='https://ppchouse-cloud.direct.yandex.net:8443/?user=readonly&query=%s'

commonLimits='''log_time > toDateTime(toInt64(now()) - 3660) and
                log_time < toDateTime(toInt64(now()) - 60) and
                not (length(upstream_response_time)=1 and has(upstream_response_time, 0)) and
                not (request_url like '%/alive')
'''

methodsDirect = ('showCamp', 'showCamps', 'editCamp', 'saveCamp', 'bannersMultiSave');
statsMethodDirect = ('showCampStat');
methodsSoap = (
  'GetBannerPhrasesFilter',
  'GetBanners',
  'SetAutoPrice',
  'GetBannerPhrases',
  'UpdatePrices',
  'CreateOrUpdateBanners',
  'GetCampaignsParams',
  'GetCampaignsList',
  'GetSummaryStat',
  'GetCampaignsListFilter',
  'GetClientsList',
  'CreateNewReport',
  'GetReportList',
  'GetBalance',
  'PayCampaigns',
  'TransferMoney',
  'GetCampaignParams',
  'GetBannersStat',
  'CreateOrUpdateCampaign',
  'campaigns',
  'adgroups',
  'ads',
  'vcards',
  'bids',
  'keywords',
  'sitelinks',
)

def getJsonFromCh(query):
    q_enc=urllib.quote(query)
    request = urllib2.Request(chUrl % q_enc)
    # FIXME 'ретрай'
    try:
        response = urllib2.urlopen(request).read().rstrip()
    except:
        response = urllib2.urlopen(request).read().rstrip()

    return json.loads(response)

def graphiteFormat(metric_name, value ):
    ts=int(time.time())
    print "%s %s %s" % (metric_name, value, ts)

def showTimings(vhost_mask, vhost_name, method, service=None):
    prcs=[0.5,0.75,0.9,0.95,0.97,0.98,0.99,1]
    service = service if service else ""
    query   = """select quantilesTiming(%s)(request_time*1000) as timings from default.nginx_access where
                %s and
                vhost = '%s' and (""" % (",".join([str(x) for x in prcs]), commonLimits, vhost_mask) + \
                " or ".join("""match(upstream_method, '%s') > 0 """ % x for x in method) + \
                ") and match(upstream_service, '%s')" % service + \
                "format JSON"
    data=getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs,js['timings']):
                graphiteFormat( "one_min.%s_yandex_ru.sla_timings.%s" % ( vhost_name, int(prc*100)), prc_timing)

def showStatTimings(vhost_mask, vhost_name, method, service=None):
    prcs=[0.5,0.75,0.9,0.95,0.97,0.98,0.99,1]
    service = service if service else ""
    query   = """select quantilesTiming(%s)(request_time*1000) as timings from default.nginx_access where
                %s and
                vhost = '%s' and (""" % (",".join([str(x) for x in prcs]), commonLimits, vhost_mask) + \
                " or ".join("""match(upstream_method, '%s') > 0 """ % x for x in method) + \
                ") and match(upstream_service, '%s')" % service + \
                """ and position(request_url, 'stat_type=campdate') == 0 format JSON"""
    data=getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs,js['timings']):
                graphiteFormat( "one_min.%s_yandex_ru.remotestat_timings.%s" % ( vhost_name, int(prc*100)), prc_timing)

    query   = """select quantilesTiming(%s)(request_time*1000) as timings from default.nginx_access where
                %s and
                vhost = '%s' and (""" % (",".join([str(x) for x in prcs]), commonLimits, vhost_mask) + \
                " or ".join("""match(upstream_method, '%s') > 0 """ % x for x in method) + \
                ") and match(upstream_service, '%s')" % service + \
                """ and position(request_url, 'stat_type=campdate') > 0 format JSON"""
    data=getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs,js['timings']):
                graphiteFormat( "one_min.%s_yandex_ru.localstat_timings.%s" % ( vhost_name, int(prc*100)), prc_timing)

if __name__ == '__main__':
    showTimings('direct.yandex.ru', 'direct', methodsDirect)
    showStatTimings('direct.yandex.ru', 'direct', statsMethodDirect)
    showTimings('api.direct.yandex.ru', 'api_direct', methodsSoap, 'direct.json-api')
