#!/usr/bin/python
# -*- coding: utf8 -*-
#
# скрипт рисует графики таймингов сервисов по данным из кликхауса (туда они попадают с серверов через mtrs-logpusher)
# при добавлении нового балансера нужно дописать сответствующий вызов showTimings в __main__ по аналогии

import urllib
import urllib2
import json
import time
import os

chUrl='https://ppchouse-cloud.direct.yandex.net:8443/?user=readonly&query=%s'

delay=120

commonLimits='''log_date = today() and
                log_time >= toStartOfMinute(toDateTime(now() - 60 - {0} )) and
                log_time < toStartOfMinute(toDateTime(now() - {0} )) and
                not (length(upstream_response_time)=1 and has(upstream_response_time, 0)) and
                not (request_url like '%/alive')
'''.format(int(delay))

def log_debug(msg):
    if not os.environ.get('DEBUG'):
        return
    print 'DEBUG: ' + msg.replace('\n', ' ').replace('\r', '')

def getJsonFromCh(query):
    q_enc=urllib.quote(query)
    request = urllib2.Request(chUrl % q_enc)
    # FIXME 'ретрай'
    try:
        response = urllib2.urlopen(request).read().rstrip()
    except:
        response = urllib2.urlopen(request).read().rstrip()

    return json.loads(response)

def graphiteFormat(metric_name, value):
    ts = int(time.time()) - delay
    print "%s %s %s" % (metric_name, value, ts)

def showTimings(vhost_mask, vhost_name, fqdn_suffix='yandex_ru', table='default.nginx_access', group_by='dc'):

    if group_by == 'dc':
        dc1 = "lower(substringUTF8(hostname, 1, 3))"
    elif group_by == 'hostname':
        dc1 = "lower(hostname)"

    query = """select %s as dc1, count()/60 as rps from %s where
                 %s and vhost like '%s' group by dc1 format JSON""" % (dc1, table, commonLimits, vhost_mask)

    log_debug('rps by ds: ' + query)

    for data in getJsonFromCh(query)['data']:
        if group_by == 'dc':
            graphiteFormat("one_min.%s-%s_%s.access_log.rps" % (vhost_name, data['dc1'], fqdn_suffix), data['rps'])
        elif group_by == 'hostname':
            graphiteFormat("one_min.%s.access_log.rps" % (data['dc1'].replace('.', '_'), ), data['rps'])


    query = """select %s as dc1, status, count() as rps from %s where
               %s and vhost like '%s' group by dc1, status format JSON""" % (dc1, table, commonLimits, vhost_mask)
    log_debug('http status by ds: ' + query)

    for data in getJsonFromCh(query)['data']:
        if group_by == 'dc':
            graphiteFormat("one_min.%s-%s_%s.access_log.%s" % (vhost_name, data['dc1'].lower(), fqdn_suffix, data['status']), data['rps'])
        elif group_by == 'hostname':
            graphiteFormat("one_min.%s.access_log.%s" % (data['dc1'].replace('.', '_'), data['status']), data['rps'])

    prcs=[0.5,0.6,0.9,0.95,0.98,0.99,1]
    query   = """select %s as dc1, quantiles(%s)(request_time*1000) as timings from %s where
                %s and vhost like '%s' group by dc1 with totals format JSON""" % (dc1, ",".join([str(x) for x in prcs]), table, commonLimits, vhost_mask)
    log_debug('timings by ds: ' + query)

    data = getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs,js['timings']):
            if group_by == 'dc':
                graphiteFormat("one_min.%s-%s_%s.access_log.timings.%s" % (vhost_name, js['dc1'].lower(), fqdn_suffix, int(prc*100)), prc_timing)
            elif group_by == 'hostname':
                graphiteFormat("one_min.%s.access_log.timings.%s" % (js['dc1'].replace('.', '_'), int(prc*100)), prc_timing)

    if group_by != 'dc':
        return
    # Данных может не быть, если не было запросов
    try:
        for (prc, prc_timing) in zip(prcs,data['totals']['timings']):
            graphiteFormat("one_min.%s_%s.access_log.timings.%s" % (vhost_name, fqdn_suffix, int(prc*100)), prc_timing)
    except:
        pass


if __name__ == '__main__':
    for field in ['dc', 'hostname']:
        showTimings('direct.yandex.ru', 'direct', table='default.nginx_access', group_by=field)
        showTimings('api.direct.yandex.ru', 'api_direct', table='default.nginx_access', group_by=field)
        showTimings('java-api.direct.yandex.net', 'api-java_direct', fqdn_suffix='yandex_net', table='default.nginx_access', group_by=field)
