#!/usr/bin/python
# -*- coding: utf8 -*-

from mysql.connector import MySQLConnection, Error
import datetime
import time
from asyncore import file_dispatcher, loop
from evdev import InputDevice, categorize, ecodes
import re


DATABASE_CONFIG = {
    'host' : 'localhost',
    'database' : 'guest_logger',
    'user' : 'root',
    'password' : 'abcd',
}


def get_query(query):
    response = []
    try:
        conn = MySQLConnection(**DATABASE_CONFIG)
        cursor = conn.cursor()
        cursor.execute(query)

        row = cursor.fetchone()

        while row is not None:
            response.append(row)
            row = cursor.fetchone()

    except Error as e:
        print e

    finally:
        cursor.close()
        conn.close()
        return response


def change_query(query):
    try:
        conn = MySQLConnection(**DATABASE_CONFIG)

        cursor = conn.cursor()
        cursor.execute(query)

        conn.commit()
    except Error as error:
        return False

    finally:
        cursor.close()
        conn.close()
        return True


def get_new_status(cur_status):
    if cur_status == 'IN':
        return 'OUT'
    else:
        return 'IN'


def open_visit(user):
    ts = time.time()
    timestamp = datetime.datetime.fromtimestamp(ts).strftime('%Y-%m-%d %H:%M:%S')

    change_query("INSERT INTO visits (id_badge, date_from) VALUES ('%s','%s')"
                 % (user[0], timestamp))


def close_visit(user):
    ts = time.time()
    timestamp = datetime.datetime.fromtimestamp(ts).strftime('%Y-%m-%d %H:%M:%S')

    change_query("UPDATE visits SET date_until='%s' WHERE id_badge='%s' AND date_until is NULL"
                 % (timestamp, user[0]))


def update_status(user):
    new_status = get_new_status(user[2])

    change_query("UPDATE users SET status='%s' WHERE id_badge='%s'" % (new_status, user[0]))


def process_guest(badge_id):
    resp = get_query("SELECT * FROM users WHERE id_badge='%s';" % (badge_id))

    if not resp:
        change_query("INSERT INTO users (id_badge, login, status) VALUES('%s', '', '%s')" % (badge_id, 'OUT'))
        resp = get_query("SELECT * FROM users WHERE id_badge='%s';" % (badge_id))

    user = resp[0]

    if user[2] == 'IN':
        close_visit(user)
    else:
        open_visit(user)

    update_status(user)


class InputDeviceDispatcher(file_dispatcher):
    badge_id = ''

    def __init__(self, device):
        self.device = device
        file_dispatcher.__init__(self, device)

    def recv(self, ign=None):
        return self.device.read()

    def handle_read(self):
        for event in self.recv():
            if event.type == ecodes.EV_KEY and categorize(event).keystate == 1:
                find_key = re.match('KEY_(.+)', categorize(event).keycode)
                key = find_key.group(1)

                if key == "LEFTSHIFT":
                    continue
                if key == "KPENTER":
                    process_guest(self.badge_id)
                    self.badge_id = ''
                else:
                    self.badge_id += key


def run():
    device = InputDevice("/dev/input/by-id/usb-PROX__www.prox.ru__RFID_reader_0-event-kbd")
    device.grab()
    InputDeviceDispatcher(device)
    loop()


if __name__ == "__main__":
    run()