# -*- coding: utf8 -*-

from app import app, render_template, request, jsonify
from mysql.connector import MySQLConnection, Error
from datetime import datetime
from flask import make_response
import json

DATABASE_CONFIG = {
    'host' : 'localhost',
    'database' : 'guest_logger',
    'user' : 'root',
    'password' : 'abcd',
}


def get_query(query):
    response = []
    try:
        conn = MySQLConnection(**DATABASE_CONFIG)
        cursor = conn.cursor()
        cursor.execute(query)

        row = cursor.fetchone()

        while row is not None:
            response.append(row)
            row = cursor.fetchone()

    except Error as e:
        print e

    finally:
        cursor.close()
        conn.close()
        return response


def change_query(query):
    success = True
    try:
        conn = MySQLConnection(**DATABASE_CONFIG)

        cursor = conn.cursor()
        cursor.execute(query)

        conn.commit()
    except Error as error:
        success = False

    finally:
        cursor.close()
        conn.close()
        return success


@app.route('/')
@app.route('/index')
def index():
    return render_template(
        'index.html',
        iframe="iframe" in request.args,
    )


@app.route('/get_guests/')
@app.route('/get_guests/<path:params>')
def get_guests(params=''):
    form = {
        'date_from': request.args.get('date_from', ''),
        'date_until': request.args.get('date_until', ''),
        'iframe': "iframe" in request.args,
    }

    if form['iframe']:
        cur_date = datetime.now().strftime("%Y-%m-%d")
        date_from = cur_date + " 00:00"
        date_until = cur_date + " 23:59"
    else:
        date_from = datetime.strptime(form['date_from'], "%H:%M %d.%m.%Y").strftime("%Y-%m-%d %H:%M")
        date_until = datetime.strptime(form['date_until'], "%H:%M %d.%m.%Y").strftime("%Y-%m-%d %H:%M")

    open_guests = get_query("""SELECT visits.id_badge, users.login, visits.date_from, visits.date_until
                               FROM visits
                               LEFT JOIN users ON visits.id_badge = users.id_badge
                               WHERE date_until IS NULL
                               ORDER BY date_from DESC;""")

    guests_data = [{
        'id_badge': guest[0],
        'login': guest[1],
        'date_from': guest[2].strftime("%H:%M:%S %d.%m.%Y"),
        'date_until': '',
        'duration': ''
    } for guest in open_guests]

    if not form['iframe']:
        guests_history = get_query(
            """
            SELECT visits.id_badge, users.login, visits.date_from, visits.date_until
            FROM visits
            LEFT JOIN users ON visits.id_badge = users.id_badge
            WHERE (date_until IS NOT NULL) AND ((date_from BETWEEN '%s' AND '%s') OR (date_until BETWEEN '%s' AND '%s'))
            ORDER BY date_until DESC;""" % (date_from, date_until, date_from, date_until)
        )

        guests_data.extend([{
            'id_badge': guest[0],
            'login': guest[1],
            'date_from' : guest[2].strftime("%H:%M:%S %d.%m.%Y"),
            'date_until': guest[3].strftime("%H:%M:%S %d.%m.%Y"),
            'duration': str(guest[3]-guest[2])
        } for guest in guests_history])

    return jsonify(guests_data)


@app.route('/get_guests_for_grafana/query', methods=['GET', 'POST', 'OPTIONS'])
def get_guests_for_grafana():

    guests = get_query("""SELECT visits.id_badge, users.login, visits.date_from, visits.date_until
                          FROM visits
                          LEFT JOIN users ON visits.id_badge = users.id_badge
                          WHERE date_until IS NULL
                          ORDER BY date_from DESC;""")

    open_guests = [[guest[1] if guest[1] else guest[0],
                    guest[2].strftime("%H:%M:%S %d.%m.%Y"),
                   ]  for guest in guests]

    data = [
        {
            "columns": [
                {
                    "text": "Login",
                    "type": "string"
                },
                {
                    "text": "Since",
                    "type": "string"
                },
            ],
            "rows": open_guests,
            "type": "table"
        }
    ]

    return grafana_response(data)


@app.route('/add_login/')
@app.route('/add_login/<path:params>')
def add_login(params=''):
    form = {
        'id_badge': request.args.get('id_badge', ''),
        'login': request.args.get('login', ''),
    }

    if not change_query("UPDATE users SET login='%s' WHERE id_badge='%s'" % (form['login'], form['id_badge'])):
        return jsonify({'success' : False})

    return jsonify({'success' : True})


@app.route('/close_visit/')
@app.route('/close_visit/<path:params>')
def close_visit(params=''):
    form = {
        'id_badge': request.args.get('id_badge', ''),
        'date': request.args.get('date', ''),
    }

    close_date = datetime.strptime(form['date'], "%H:%M:%S %d.%m.%Y").strftime("%Y-%m-%d %H:%M:%S")

    if not change_query("UPDATE users SET status='%s' WHERE id_badge='%s'" % ('OUT', form['id_badge'])):
        return jsonify({'success' : False})

    if not change_query("UPDATE visits SET date_until='%s' WHERE id_badge='%s' AND date_until is NULL"
                 % (close_date, form['id_badge'])):
        return jsonify({'success': False})

    return jsonify({'success' : True})


def grafana_response(data):
    response = make_response(json.dumps(data))
    response.headers['Access-Control-Allow-Headers'] = 'accept, content-type'
    response.headers['Access-Control-Allow-Methods'] = 'POST'
    response.mimetype = 'application/json'
    response.headers['Access-Control-Allow-Origin'] = '*'
    return response

