use strict;
use warnings;

use FindBin qw/$Bin/;
use Test::More;
use Test::Exception;
use YAML;
use Data::Dumper;
use Path::Tiny;
use File::Slurp;


my @tests = (
    {
        title => 'reject-to, цепочек и правил нет',
        args => 'reject-to 127.0.0.1 80',
        dir => 'reject-to',
    },
    {
        title => 'clear-reject-to, есть цепочка и правило',
        args => 'clear-reject-to 127.0.0.1 80',
        dir => 'clear-reject-to',
    },
    {
        title => 'reject-from-any, когда нет ни цепочек, ни правил',
        args => 'reject-from-any 8000,5000',
        dir => 'reject-from-any',
    },
    {
        title => 'clear-reject-from-any, есть цепочки и правила от reject-from-any 8000,5000',
        args => 'clear-reject-from-any 8000,5000',
        dir => 'clear-reject-from-any',
    },
    {
        title => 'clear-all, когда есть цепочки и правила',
        args => 'clear-all',
        dir => 'clear-all',
    },
    {
        title => 'fence-host, цепочек и правил нет',
        args => 'fence-host',
        dir => 'fence-host',
    },
    {
        title => 'clear-fence-host, все цепочки и правила есть',
        args => 'clear-fence-host',
        dir => 'clear-fence-host',
    },
);

for my $tc (@tests) {
    my $my_iptables = "$Bin/$tc->{dir}/mock_iptables";
    my $answer = read_file("$Bin/$tc->{dir}/answer");
    $answer =~ s/^\s*dry-run: executing [^\s]+\s+//gm;
    $answer =~ s/[\s\n]+$//;

    $tc->{args} = "--dry-run $tc->{args}";

    my $cmd_to_run = "$Bin/../bin/iptblocker --iptables-bin $my_iptables --ip6tables-bin $my_iptables $tc->{args} 2>&1";
    diag("run $cmd_to_run");
    my $output = `$cmd_to_run`;

    if ($output) {
        $output =~ s/^\s*dry-run: executing [^\s]+\s+//gm;
        $output =~ s/[\s\n]+$//;
    }

    #diag("$output\n\n\n$answer\n\n");
    ok($? == 0 && $output eq $answer, $tc->{title});
}

done_testing();
