# -*- coding: utf-8 -*-
from __future__ import absolute_import

from . import api, CheckFilter
from . import common
from . import errors
from . import check_sync


class AnsibleJugglerApi(api.JugglerApi):
    def __init__(self, *args, **kwargs):
        super(AnsibleJugglerApi, self).__init__(*args, **kwargs)

    def make_check(self, host, service, aggregator=None, aggregator_kwargs=None,
                   active=None, active_kwargs=None, ttl=None, refresh_time=None,
                   responsible=None, alert_method=None, children=None,
                   flap=None, notifications=None, tags=None, meta=None,
                   check_options=None, namespace=None, **kwargs):
        """Создает новый инстанс класса Check

        :param host: хост агрегата
        :param service: сервис агрегата
        :param aggregator: определяет логику агрегации событий
        :param aggregator_kwargs: словарь с параметрами агрегации
        :param active: тип активной проверки
        :param active_kwargs: словарь с параметрами активной проверки
        :param ttl: через сколько зажигать NO DATA если событие не приходит на сервер
        :param refresh_time: верхняя граница частоты пересчёта агрегата
        :param responsible: список пользователей ответственных за хост в Големе
        :param alert_method: методы нотификации, deprecated
        :param children: список событий, которые входят в агрегат
        :param flap: настройки флаподава
        :param notifications: сконфигурировать правила отправки уведомлений по агрегату
        :param tags: список тэгов, которые нужно будет навесить на агрегат
        :param meta: словарь с произвольными метаданными
        :param check_options: опции запуска пассивной проверки
        :param namespace: неймспейс агрегата
        """
        params = common.cleanup_none(dict(
            host=host,
            service=service,
            jcheck_mark=self.mark,
            aggregator=aggregator,
            aggregator_kwargs=aggregator_kwargs,
            active=active,
            active_kwargs=active_kwargs,
            ttl=ttl,
            refresh_time=refresh_time,
            responsible=responsible,
            alert_method=alert_method,
            children=children,
            flap=flap,
            notifications=notifications,
            tags=tags,
            meta=meta,
            check_options=check_options,
            namespace=namespace,
        ))
        params.update(kwargs)

        return check_sync.make_check_from_ansible_dict(params, self._context)

    def get_checks(self, host=None, service=None, tags=None, namespace=None, **kwargs):
        if kwargs:
            raise errors.ValidationError("Extra options passed to get_checks: {0!r}".format(kwargs))

        return super(AnsibleJugglerApi, self).get_checks([CheckFilter(
            host=host, service=service, namespace=namespace, tags=tags
        )])

    def get_context(self):
        return self._context

    def get_seen_checks(self):
        return self._seen_checks

    def get_seen_marks(self):
        return self._seen_marks

    def update_seen_checks(self, seen_checks, seen_marks):
        self._seen_checks.update(seen_checks)
        self._seen_marks.update(seen_marks)
