# -*- coding: utf-8 -*-
from __future__ import absolute_import

import urllib
import urllib2
import json

from . import const
from . import errors


def str_none(value):
    return None if value is None else str(value)


def list_of_str(value):
    return [str(value)] if isinstance(value, basestring) else map(str, value)


_no_value = object()


def dict_based_equality(class_def):
    def equals(left, right):
        return type(left) is type(right) and left.__dict__ == right.__dict__

    def __ne__(left, right):
        return not left == right

    class_def.__eq__ = equals
    class_def.__ne__ = __ne__

    return class_def


def cleanup_none(d):
    return {k: v for k, v in d.iteritems() if v is not None}


def pop_value(data, key, default=_no_value):
    value = data.pop(key, default)
    if value is _no_value:
        raise errors.ValidationError('Option {0!r} is required'.format(key), not_parsed=data)
    return value


def _canon_query_value(value):
    if isinstance(value, basestring):
        return value
    elif callable(getattr(value, 'serialize_server', None)):
        return value.serialize_server()
    else:
        return json.dumps(value)


def _fetch_raw_body(base, handle, body=None, headers=None, oauth_token=None, **kwargs):
    query_string = []
    for k, v in sorted(kwargs.iteritems()):
        if isinstance(v, (list, tuple)):
            for v__ in v:
                query_string.append((k, _canon_query_value(v__)))
        else:
            query_string.append((k, _canon_query_value(v)))

    url = base + handle + '?' + urllib.urlencode(query_string)

    actual_headers = {"User-Agent": const.USER_AGENT + '/' + const.VERSION}
    if headers:
        actual_headers.update(headers)

    if oauth_token:
        actual_headers['Authorization'] = 'OAuth ' + oauth_token

    request = urllib2.Request(url=url, data=body, headers=actual_headers)
    try:
        fd = urllib2.urlopen(request, timeout=30)
    except urllib2.HTTPError as e:
        ename = type(e).__name__
        raise errors.JugglerError('HTTP API call failed, %s: %s' % (ename, e),
                                  url=url,
                                  code=e.getcode(),
                                  body=e.read(),
                                  headers=dict(e.info()))
    except Exception as e:
        ename = type(e).__name__
        raise errors.JugglerError('HTTP API call failed, %s: %s' % (ename, e),
                                  url=url)

    try:
        data = fd.read()
    except Exception as e:
        ename = type(e).__name__
        raise errors.JugglerError('Unable to read HTTP reply, %s: %s' % (ename, e),
                                  url=url,
                                  code=fd.getcode(),
                                  headers=dict(fd.info()))
    else:
        return data, url, fd


def fetch_json(context, handle, api_url=None, body=None, headers=None, **kwargs):
    kwargs["do"] = 1
    headers = headers or {}
    headers['content-type'] = 'application/json'
    data, url, fd = _fetch_raw_body(api_url or context.api_url, handle, body, headers, context.oauth_token, **kwargs)

    try:
        data = json.loads(data)
    except Exception as e:
        ename = type(e).__name__
        raise errors.JugglerError('Unable to read JSON reply from juggler-server, %s: %s' % (ename, e),
                                  url=url,
                                  code=fd.getcode(),
                                  body=data,
                                  headers=dict(fd.info()))
    else:
        return data
