# -*- coding: utf-8 -*-
# pylint: disable=missing-docstring,invalid-name,too-many-locals,line-too-long,too-many-branches

from __future__ import absolute_import, unicode_literals

from . import common
from . import types


class Context(object):
    def __init__(self, api_url, oauth_token):
        self.api_url = api_url
        self.oauth_token = oauth_token

        config_tree = common.fetch_json(self, '/api/system/config_tree')
        flap = config_tree['flap']
        known_active = common.fetch_json(self, '/api/actives/actives').keys()
        known_aggregator = common.fetch_json(self, '/api/aggregators/aggregators').keys()

        self.golem_read_url = config_tree['golem']['url_ro']
        self.default_ttl = config_tree['main']['default_check_ttl']
        self.default_refresh_time = config_tree['main']['default_check_refresh_time']
        self.new_check_downtime = config_tree['jctl']['new_check_downtime']
        self.default_flaps = types.FlapOptions(
            stable=flap['default_stable_time'],
            critical=flap['default_critical_time'],
            boost=flap['default_boost_time']
        )
        self.known_actives = known_active
        self.known_aggregators = known_aggregator

        # hostname -> list of responsible users
        self.golem_responsible_cache = {}
        # (host, service) -> Check
        self.server_checks_cache = {}
        # marks fetched from server at some point and cached in checks cache
        self.fetched_marks = set()
