# -*- coding: utf-8 -*-
from __future__ import absolute_import

from . import types
from . import common


def check_from_api_v1_reply(host, service, obj):
    return types.Check(
        host=host,
        service=service,
        aggregator=obj['aggregator'],
        aggregator_kwargs=obj['aggregator_kwargs'],
        active=obj['active'],
        active_kwargs=obj['active_kwargs'],
        check_options=obj.get('check_options'),
        ttl=obj['ttl'],
        refresh_time=obj['refresh_time'],
        responsible=None,
        alert_methods=obj['methods'] or [],
        alert_interval=obj['alert_interval'] if obj['alert_interval'][0] else None,
        children=[types.Child(
            group_type=None if x['type'] == 'HOST' else x['type'],
            host=x['host'],
            service=x['service'],
            instance=x['instance'] or ""
        ) for x in obj['children']],
        flaps_config=types.FlapOptions(
            stable=obj['stable_time'],
            critical=obj['critical_time'],
            boost=obj['boost_time']
        ) if obj['stable_time'] or obj['critical_time'] else None,
        notifications=[types.NotificationOptions(
            template_name=x['template_name'],
            template_kwargs=x['template_kwargs'],
            description=x['description']
        ) for x in obj['notifications']],
        tags=obj['tags'] or [],
        meta=obj['meta'],
        namespace=obj['namespace'],
        description=obj['description'],
    )


def child_to_add_or_update_object(child):
    return {
        'type': child.group_type,
        'host': child.host,
        'service': child.service,
        'instance': child.instance
    }


def check_to_add_or_update_object(check, description=None):
    result = {
        "host": check.host,
        "service": check.service,
        "description": description or check.description,
        "aggregator": check.aggregator,
        "aggregator_kwargs": check.aggregator_kwargs,
        "active": check.active,
        "active_kwargs": check.active_kwargs,
        "check_options": check.check_options,
        "flaps": common.cleanup_none({
            "stable_time": check.flaps_config.stable,
            "critical_time": check.flaps_config.critical,
            "boost_time": check.flaps_config.boost,
        }) if check.flaps_config is not None else None,
        "tags": check.tags,
        "methods": check.alert_methods,
        "alert_interval": check.alert_interval,
        "children": map(child_to_add_or_update_object, check.children),
        "notifications": [
            {
                "template_name": notify.template_name,
                "template_kwargs": notify.template_kwargs,
                "description": notify.description
            } for notify in check.notifications
        ],
        "namespace": check.namespace,
        "meta": check.meta
    }
    if check.ttl is not None:
        result["ttl"] = check.ttl
    if check.refresh_time is not None:
        result["refresh_time"] = check.refresh_time
    return result
