# -*- encoding: utf-8

from __future__ import absolute_import, unicode_literals

from pprint import pformat


class JugglerError(Exception):
    def __init__(self, msg, **kwargs):
        self.msg = msg
        self.kwargs = kwargs
        super(JugglerError, self).__init__(msg)

    def __str__(self):
        if self.kwargs:
            return '{0}\ndetails: {1}'.format(self.msg, pformat(self.kwargs))
        else:
            return self.msg


class ValidationError(JugglerError):
    pass
