# -*- coding: utf-8 -*-
# pylint: disable=missing-docstring,invalid-name,too-many-locals,line-too-long,too-many-branches

from __future__ import absolute_import, unicode_literals

from . import common
from . import converters
from . import types
from . import errors


@common.dict_based_equality
class CheckFilterResult(types.CheckFilter):
    def __init__(self, success, message, *args, **kwargs):
        super(CheckFilterResult, self).__init__(*args, **kwargs)
        self.success = success
        self.message = message


@common.dict_based_equality
class ChecksHandleReply(object):
    """
    Результат фильтрации проверок по набору фильтров

    :param filters: примененые фильтры
    :param checks: полученные проверки
    :type checks: list[juggler_sdk.Check]
    """

    def __init__(self, filters, checks):
        self.filters = filters
        self.checks = checks


def list_checks(context, filters):
    unconverted_checks = {}
    filter_results = []

    for checks_filter in filters:
        host = common.list_of_str(checks_filter.host or [])
        service = common.list_of_str(checks_filter.service or [])
        tags = common.list_of_str(checks_filter.tags or [])
        namespace = common.list_of_str(checks_filter.namespace or [])

        try:
            reply = common.fetch_json(context,
                                      handle='/api/checks/checks',
                                      host_name=host,
                                      service_name=service,
                                      tag_name=tags,
                                      namespace_name=namespace,
                                      include_meta=True,
                                      include_children=True,
                                      include_notifications=True)
        except errors.JugglerError as e:
            success, message = False, str(e)
        else:
            success, message = True, None
            for host, svc_dict in reply.iteritems():
                for service, params in svc_dict.iteritems():
                    unconverted_checks[(host, service)] = params
        finally:
            filter_results.append(CheckFilterResult(
                host=checks_filter.host,
                service=checks_filter.service,
                tags=checks_filter.tags,
                namespace=checks_filter.namespace,
                success=success,
                message=message
            ))

    checks_list = [converters.check_from_api_v1_reply(host, service, params)
                   for (host, service), params
                   in unconverted_checks.iteritems()]
    checks_list.sort(key=lambda x: (x.host, x.service))
    return ChecksHandleReply(
        filters=filter_results,
        checks=checks_list
    )
