# -*- coding: utf-8 -*-

from __future__ import absolute_import, unicode_literals

from . import common
from . import errors


class FilterRemoveResult(object):
    """
        Результат чистки проверок на сервере

        :param success: прошло ли удаление успешно
        :param message: сообщение об ошибке, если такая была
        :param removed: список ключей удаленных проверок
        :type removed: list[tuple[host, service]]
        """

    def __init__(self, success, message, removed, query):
        self.filter = query
        self.success = success
        self.message = message
        self.removed = removed


class RemoveResult(object):
    """
    Результат удаления проверок на сервере

    :param results: список результатов по каждому фильтру
    :type results: list[FilterRemoveResult]
    """

    def __init__(self, results):
        self.results = results


def remove_checks(context, filters):
    filter_results = []

    for checks_filter in filters:
        host = common.list_of_str(checks_filter.host or [])
        service = common.list_of_str(checks_filter.service or [])
        tags = common.list_of_str(checks_filter.tags or [])
        namespace = common.list_of_str(checks_filter.namespace or [])

        removed_checks = []
        try:
            reply = common.fetch_json(context,
                                      handle='/api/checks/list_checks',
                                      host_name=host,
                                      service_name=service,
                                      tag_name=tags,
                                      namespace_name=namespace)
            for host, svc_dict in reply.iteritems():
                removed_checks.extend((host, service) for service in svc_dict.iterkeys())
        except errors.JugglerError as e:
            filter_results.append(FilterRemoveResult(
                success=False, message=str(e), removed=[], query=checks_filter
            ))
            continue
        if not removed_checks:
            filter_results.append(FilterRemoveResult(
                success=False, message="No checks matching filter found", removed=[], query=checks_filter
            ))

        try:
            common.fetch_json(
                context,
                handle='/api/checks/remove_check',
                host_name=host,
                service_name=service,
                tag_name=tags,
                namespace_name=namespace
            )
        except errors.JugglerError as e:
            filter_results.append(FilterRemoveResult(
                success=False, message=str(e), removed=[], query=checks_filter
            ))
        else:
            filter_results.append(FilterRemoveResult(
                success=True, message=None, removed=removed_checks, query=checks_filter
            ))

    return RemoveResult(results=filter_results)
