#!/bin/bash -ex

if [ -z "$1" ]; then
    cgroup=$(curl -s "https://c.yandex-team.ru/api/hosts/$(hostname -f)?format=json" | jq -r '.[0].group')
else
    cgroup=$1
fi

case $cgroup in
    direct_frontends*|direct_fake_ci)
        cluster=direct_front_perl
    ;;
    direct_soap*)
        cluster=direct_soap_perl
    ;;
    direct_intapi_rtc|direct_ng_backs_prod)
        cluster=direct_intapi_perl
    ;;
    direct_frontends_sandbox)
        cluster=direct_sandbox_perl
    ;;
    direct_limtest)
        cluster=direct_limtest_perl
    ;;
    direct_scripts_rtc|direct_fake_ppcscripts)
        cluster=direct_scripts_perl
    ;;
    direct_export_rtc)
        cluster=direct_export_perl
    ;;
    *)
        echo "unknown cluster, exiting"
        exit 1
    ;;
esac

mkdir -p /local/cache/logbackup-to-yt/{build-filelists-log,filelists}

logbackup-build-filelists.py -l /var/log/yandex -l /var/www/ppc.yandex.ru/protected/logs \
-d /local/cache/logbackup-to-yt/filelists \
-u $(hostname -f) -c $cluster \
-i '^.*\.gz$' \
-e '\.to-delete$' \
-e '^ppclog_api\.log\b' \
-e '^ppclog_cmd\.log\b' \
-e '^ppclog_price\.log\b' \
-e '^trace\.log\b' \
-e '^rbac_queries\.log\b' \
-e '^AutobudgetPrices_set\.log\b' \
-e '^bsexport.*' \
-e '^bs_full_lb_export.*' \
-e '^profile\.log.*' \
-e '^messages\..*' \
-e '^bsUpdateOrderTargetStat\.stat\.log.*' \
-e '^moderate\..*' \
2>> /local/cache/logbackup-to-yt/build-filelists-log/build-filelists.log.$(date +%Y%m%d)
