#!/bin/bash -e
lenv=$1
threads=${2:-$((`cat /proc/cpuinfo | grep -c processor` - 1))}
if [ -z "$lenv" -o -z "$threads" ]; then
    echo "Usage: $0 {test|prod} threads_count"
    exit 1
fi
dir=/local/cache/logbackup-to-yt

prefix='//tmp/du-logbackup'
if [ "$lenv" = "prod" ]; then
    prefix='//home/direct/logs/logbackup'
fi

mkdir -p $dir/upload-to-yt.{stat,log}.$lenv

statdir="$dir/upload-to-yt.stat.$lenv"
logdir="$dir/upload-to-yt.log.$lenv"

cd $dir/filelists

running=$(ps -e -o cmd | grep "^python /usr/local/bin/logbackup-to-yt.py --table-prefix $prefix" | wc -l)
free_slots=$((threads - running))

filter=$(ps -e -o cmd | grep "^python /usr/local/bin/logbackup-to-yt.py --table-prefix $prefix" | perl -lne 'BEGIN { @l = qw(none) }; /--filelist\s+(\S+)/ && push @l, $1; END { print join "|", @l }')
filelists=$(ls -1 *.list | grep -vE "$filter" || echo "none")

if [ $free_slots -le 0 ]; then
    echo "$running threads running, $threads requested, exiting"
    echo "running filelists: $filter"
    exit 0
else
    echo "run $free_slots threads for"
    echo "$filelists" | tr '\n' '|'
    echo
fi

# скрипт либо держит лок на файллист, либо этот файллист уже полностью загружен, проблем с повторным запуском не будет
echo "$filelists" | xargs -n1 -P $free_slots -I{} bash -c "/usr/local/bin/logbackup-to-yt.py --table-prefix $prefix --yt-token-path /etc/direct-tokens/yt_robot-direct-yt --stat-dir $statdir --script-log-file $logdir/{}.log --filelist {} 2>&1 | ts >> $statdir/{}.run" &
