#!/usr/bin/python
# -*- coding: utf8 -*-

import gzip
import imp
import os
import cStringIO as StringIO
import unittest

filedir = os.path.dirname(__file__)
l = imp.load_source('logbackup', filedir + '/../bin/logbackup-to-yt.py')

class Test(unittest.TestCase):
    def test_read_chunk(self):
        stream = StringIO.StringIO()
        stream.write('12345\n789A\n\n\nFG\n\nH\n\n\nI\n')
        stream.seek(0)

        extra_data = ''
        data, extra_data, err = l.read_chunk(stream, extra_data, 4)
        self.assertEqual(data, '1234')
        self.assertEqual(extra_data, '')

        data, extra_data, err = l.read_chunk(stream, extra_data, 4)
        self.assertEqual(data, '5\n')
        self.assertEqual(extra_data, '78')

        data, extra_data, err = l.read_chunk(stream, extra_data, 4)
        self.assertEqual(data, '789A')
        self.assertEqual(extra_data, '')

        data, extra_data, err = l.read_chunk(stream, extra_data, 4)
        self.assertEqual(data, '\n\n\nF')
        self.assertEqual(extra_data, '')

        data, extra_data, err = l.read_chunk(stream, extra_data, 4)
        self.assertEqual(data, 'G\n\n')
        self.assertEqual(extra_data, 'H')

        data, extra_data, err = l.read_chunk(stream, extra_data, 3)
        self.assertEqual(data, 'H\n\n')
        self.assertEqual(extra_data, '')

        data, extra_data, err = l.read_chunk(stream, extra_data, 2)
        self.assertEqual(data, '\nI')
        self.assertEqual(extra_data, '')

        data, extra_data, err = l.read_chunk(stream, extra_data, 5)
        self.assertEqual(data, '\n')
        self.assertEqual(extra_data, '')

        data, extra_data, err = l.read_chunk(stream, extra_data, 5)
        self.assertEqual(data, '')
        self.assertEqual(extra_data, '')

    def test_write_context(self):
        wc = l.init_write_context()
        wc['filelist_pos_file'] = 'filelist_pos_file'
        wc['log_pos_file'] = 'log_pos_file'
        wc['stat_file'] = 'stat_file'
        wc['table_path'] = 'table_path'
        wc['filelist_line'] = 123
        wc['log_pos']['byte'] = 10
        wc['log_pos']['chunk'] = 2
        wc['log_pos']['path'] = 'logpath'
        wc['stat'].append('file1')
        wc['stat'].append('file2')
        wc['timings']['compress'] = 1
        wc['timings']['read'] = 2
        wc['timings']['serialize'] = 3
        wc['gzip_stream'].write('data\ndata2\ndata3')
        wc['gzip_stream'].flush()

        wc_u = l.prepare_write_context_for_upload(wc)
        wc_u['gzip_stream'].close()
        wc_u['stream'].seek(0)

        wc['filelist_line'] = 124
        wc['gzip_stream'].write('newdata\nnewdata2\nnewdata3')
        wc['gzip_stream'].flush()
        wc['gzip_stream'].close()
        wc['stream'].seek(0)
        wc['log_pos']['byte'] = 15
        wc['stat'].append('file3')

        self.assertEqual(wc_u['log_pos']['byte'], 10)
        self.assertEqual(wc_u['stat'][1], 'file2')
        self.assertEqual(wc_u['filelist_line'], 123)
        self.assertEqual(gzip.GzipFile(fileobj=wc_u['stream'], mode='rb').read(), 'data\ndata2\ndata3')

        self.assertEqual(wc['log_pos']['byte'], 15)
        self.assertEqual(wc['stat'][0], 'file3')
        self.assertEqual(wc['filelist_line'], 124)
        self.assertEqual(gzip.GzipFile(fileobj=wc['stream'], mode='rb').read(), 'newdata\nnewdata2\nnewdata3')


if __name__ == '__main__':
    unittest.main()

