#!/usr/bin/python
# -*- coding: utf-8 -*-

import MTRSLogpusher
import os
import sys
import time
import psutil
from optparse import OptionParser
from Monitoring import accumulator

parser = OptionParser()
parser.add_option(  "-j", "--juggler",
                    action="store_true",
                    dest="juggler", help="dont print sys.stderr"
)

(opts, args) = parser.parse_args()

if opts.juggler:
    sys.stderr = ''

#status = [ proc.pid for proc in psutil.process_iter() if psutil.pid_exists(proc.pid) and proc.name == 'logpusher.py']

# возможна ситуация, когда процесс мог завершиться, когда началась проверка. Делаем 3 попытки.
status = list()
for _ in range(3):
    try:
        for proc in psutil.process_iter():
            if not psutil.pid_exists(proc.pid): continue
            if proc.name != 'logpusher.py': continue
            status.append(proc.pid)
            break
    except Exception as err:
        time.sleep(1)
        pass

if len(status) == 0:
    print '2;logpusher is not runing'
    exit(0)

def get_size(file):
    if os.path.isfile(file):
        return os.stat(file).st_size
    else:
        return None

config = MTRSLogpusher.get_config()
# если нет кофига, то выходим с ошибкой
if config is None:
    print '2;error read logpusher config'
    exit(0)

# отсекаем секции с [main]. Возможна ситуация, когда проверка запускается в момент
# обновления конфига и его может не быть. Выходим с exit(0).
sections = [i for i in config.keys() if i != 'main']
if len(sections) == 0:
    print '0;not found any sections'
    exit(0)

result = accumulator(showCodeNames=False)
for section in sections:
    if section == 'main':
        continue
    # отсутствие лога для отправки не является критичной ошибкой работы программы.
    logfile = config[section].file
    logfilesize = get_size(logfile)
    if not logfilesize:
        result.append(0, "not found log %s" % logfile)
        continue

    # провераяем кэш. Если inode=0, cachedlogpos=0 - кэша нет. Возможнопоявление нового конфига,
    # желательно перезапустить logpusher.
    inode, cachedlogpos, first_run = MTRSLogpusher.getLogPos(logfile, section, config.main.cache_dir)
    if not cachedlogpos and not inode:
        result.append(2, "no cache for %s" % logfile)
        continue

    # превышение порога отправки говорит о поломке программы. Желателен перезапуск.
    threshold = config[section].mon_threshold
    delay = int(logfilesize - cachedlogpos)
    if delay >= threshold:
        result.append(2, "delay for %s is %d offsets" % (logfile, delay))
    else:
        result.append(0, "%s is OK" % logfile)

print result.result()
