#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
Сначала посчитать количество объектов, которые можем удалить и их суммарный размер.
Это делает соседний скрипт bin/dt-s3-dna-count-freeable-space.py, запускать без параметров с sudo, при 6млн накопленных объектов работает 15 минут

sudo bin/dt-s3-dna-count-freeable-space.py

Потом в этом скрипте поменять строчку с присваиванием MAX_OBJECTS_TO_DELETE

на то количество объектов, которые согласны удалить (ориентироваться на статистику из предыдущего скрипта)

Запустить без параметров, с sudo, stdout отправлять в файл -- будет писать имена всех удаляемых объектов

График объема данных в бакете: https://nda.ya.ru/t/xevzZeGH3pm7e3

"""


from datetime import datetime, timedelta
from boto.s3.connection import S3Connection
from boto.s3.key import Key
from pprint import pprint

access_key_id = open('/etc/direct-tokens/s3_robot-twilight_access_key_id').readline().rstrip()
secret_access_key = open('/etc/direct-tokens/s3_robot-twilight_secret_access_key').readline().rstrip()

s3=S3Connection(host='s3.mds.yandex.net',aws_access_key_id=access_key_id,aws_secret_access_key=secret_access_key)
bucket = s3.get_bucket('direct-dna')
keys = bucket.list()
MAX_OBJECTS_TO_DELETE = 2000000
deleted_objects = 0
deleted_objects_size = 0
to_delete_chunk_size = 1000
to_delete_chunk = []
for k in keys:
    last_modified_date = datetime.strptime(k.last_modified, '%Y-%m-%dT%H:%M:%S.%fZ')
    last_modified_delta = datetime.now() - last_modified_date
    if k.name.startswith('betas/') and last_modified_delta.days > 30:
        print k.name, k.last_modified, k.size
        to_delete_chunk.append(k)
        if len(to_delete_chunk) >= to_delete_chunk_size:
            bucket.delete_keys([obj.name for obj in to_delete_chunk])
            deleted_objects += len(to_delete_chunk)
            deleted_objects_size += sum([ obj.size for obj in to_delete_chunk ])
            to_delete_chunk = []
    if deleted_objects >= MAX_OBJECTS_TO_DELETE:
        break

print "deleted objects: %s\ndeleted objects size: %s" % (deleted_objects, deleted_objects_size)

