#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
считает сколько старой статики с бет можно удалитьиз s3/direct-dna

Выводит количество объектов и суммарный размер в байтах

Запускать с ppcdev, с sudo, без параметров

sudo bin/dt-s3-dna-count-freeable-space.py

6 млн объектов / 1.8TB считает за 15 минут

Если понятно, что старых объектов много -- можно их удалять соседним скриптом dt-s3-dna-cleanup.py

"""

from datetime import datetime, timedelta
from boto.s3.connection import S3Connection
from boto.s3.key import Key
from pprint import pprint


access_key_id = open('/etc/direct-tokens/s3_robot-twilight_access_key_id').readline().rstrip()
secret_access_key = open('/etc/direct-tokens/s3_robot-twilight_secret_access_key').readline().rstrip()

s3=S3Connection(host='s3.mds.yandex.net',aws_access_key_id=access_key_id,aws_secret_access_key=secret_access_key)
bucket = s3.get_bucket('direct-dna')
keys = bucket.list()
deletable_size = 0
deletable_keys = 0
for k in keys:
    last_modified_date = datetime.strptime(k.last_modified, '%Y-%m-%dT%H:%M:%S.%fZ')
    last_modified_delta = datetime.now() - last_modified_date
    if k.name.startswith('betas/') and last_modified_delta.days > 30:
        #print k.name, k.last_modified, k.size
        deletable_size += k.size
        deletable_keys += 1
print 'Freeable space: %s\nObjects: %s' % (str(deletable_size), deletable_keys)
