use strict;
use warnings;

package MigratorB::Env::Direct::ts; 

use base('MigratorB::Env::Direct::Base');

use Data::Dumper;

use utf8;


=head2 get_cmd_for_sql

    Составляет shell-команду для применения заданного sql-запроса в заданной базе (и заданной конфигурации)

    Параметры именованные
        db   -- название базы, в которой должен выполняться запрос
        sql  -- запрос

=cut
sub sql2cmd
{
    my ($self, %O) = @_;

    return $self->_sql2cmd_via_test_update("test1", %O);
}


=head2 

    Составляет shell-команду для применения заданного скрипта к заданной конфигурации

    Параметры именованные: 
        scripts_wc -- (для конфигурации devtest) рабочая копия, из которой надо брать скрипты
        script -- имя скрипта (относительно корня рабочей копии Директа)

=cut
sub script2cmd
{
    my ($self, %O) = @_;

    return $self->_script2cmd_via_test_update("test1", %O);
}


=head2 

    Добавляет к миграциям shell-команды, необходимые для применения миграции

    В каждом задании появляется массив execute

=cut
sub compile_actions
{
    my ($self, $migrations, $opt) = @_;

    for my $m (@$migrations){
        next if $m->{format} eq 'plaintext';
        for my $task ( @{$m->{tasks}} ){
            if ( $task->{type} eq 'sql' ){ 
                for my $sql ( @{$task->{sql}} ){
                    push @{$task->{execute}}, $self->sql2cmd(db => $task->{db}, sql => $sql);
                }
            } elsif ( $task->{type} eq 'script' ){
                for my $script ( @{$task->{script}} ){
                    push @{$task->{execute}}, $self->script2cmd(script => $script, scripts_wc => $opt->{scripts_wc});
                }
            } elsif ( $task->{type} eq 'manual' ) {

            } else {
                $self->message("$m->{filename}: unknown migration type $task->{type}");
            }
        }
    }

    return; 
}



1;
