use strict;
use warnings;

package MigratorB::Env::Base;


sub new 
{
    my $class = shift;
    my %O = @_;

    my $self = \%O;

    return bless $self, $class;
}


sub check_methods
{
    return 0;
}


=head2 execute_migrations

    Выполняет миграции (запускает соответсвующие команды)

    На входе -- скомпилированные миграции, 
    возвращаемого значения нет. 

=cut
sub execute_migrations
{
    my ($self, $migrations, $opt) = @_;

    if ($opt->{print_task_count_only}){
        print join" ", map {scalar @{$_->{tasks}}} @$migrations;
        return;
    }

    print "### configuration: $opt->{conf}\n";

    my $fc = 0;
    for my $m (@$migrations){
        $fc++;
        print "#### $fc. $m->{filename}\n";
        print "errors: ".join( "\n", @{$m->{errors}})."\n" if @{$m->{errors}||[]};
        print "text:\n$m->{text}\n" if $opt->{print_text_only};
        
        next if $opt->{print_text_only};

        if ( $m->{format} eq 'plaintext' ){
            $self->message("skipping old-format file...");
            next;
        }

        my $tc = 0;
        for my $t ( @{$m->{tasks}} ){
            $tc++;
            print "#### $fc.$tc. comment: $t->{comment}\n" if $t->{comment};

            print("skipping manual task...\n"), next if $t->{type} eq 'manual';

            my $ac = 0;
            for my $action ( @{$t->{execute}} ){
                $ac++;
                print "#### $fc.$tc.$ac. to execute:\n$action\n"; 
                my $t1 = time;
                qx/$action/ unless $opt->{dry_run};
                my $t2 = time;
                print "done in ".($t2 - $t1)." seconds\n\n";
            }
        }
    }

    return;
}


sub message
{
    my ($self, $message, $opt) = @_;

    print "$message\n";
}

1;
