#!/usr/bin/perl
# без -w из-за ворнингов в DBIx::MyParsePP

=head1 TEST

    проверяем разбор структурированных миграций

    $Id$

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;
use  Yandex::Metadata;
use Data::Dumper;

use FindBin qw/$Bin/;
require "$Bin/../bin/migrator";

use utf8;

# корректные миграции, должны корректно обрабатываться 
my @correct_tests = (
    {
        name => 'simple sql',
        task_count => 1,
        filename => 'file.migr',
        file => q%{
            type => 'sql', 
            db => 'ppc',
            when => 'before',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        }
        %,
    },
    {
        name => 'sql + filename without .migr + shebang',
        task_count => 1,
        filename => 'file',
        file => q%#.migr
        {
            type => 'sql', 
            db => 'ppc',
            when => 'before',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        }
        %,
    },
    {
        name => 'simple sql x2',
        task_count => 2,
        filename => 'file.migr',
        file => q%[
        {
            type => 'sql', 
            db => 'ppc',
            when => 'before',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        },
        {
            type => 'sql', 
            db => 'db2',
            when => 'after',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c2 int'
        },
        ]
        %,
    },
    {
        name => 'sql + external sript',
        task_count => 2,
        filename => 'file.migr',
        file => q%[
        {
            type => 'sql', 
            db => 'ppc',
            when => 'any',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        },
        {
            type => 'script', 
            when => 'after',
            time_estimate => '3 сек.',
            script => '/usr/local/bin/script.pl',
        },
        ]
        %,
    },
    {
        name => '.pl migration + sql',
        task_count => 2,
        filename => 'file.pl',
        file => q%
=head1 DEPLOY 
        #.migr
        [
        {
            type => 'sql', 
            db => 'ppc',
            when => 'any',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        },
        {
            type => 'script', 
            when => 'after',
            time_estimate => '3 сек.',
        },
        ]
=cut

print "Hello world";
        %,
    },
);

# неструктурированные миграции: 
# обрабатываются, но с предупреждением про plaintext format
my @plaintext_tests = (
    {
        name => 'sql + filename without .migr',
        task_count => 0,
        filename => 'file',
        file => q%{
            type => 'sql', 
            db => 'ppc',
            when => 'before',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        }
        %,
    },
    {
        name => '.pl migration + sql without shebang',
        task_count => 0,
        filename => 'file.pl',
        file => q%
=head1 DEPLOY 
        [
        {
            type => 'sql', 
            db => 'ppc',
            when => 'any',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        },
        {
            type => 'script', 
            when => 'after',
            time_estimate => '3 сек.',
        },
        ]
=cut

print "Hello world";
        %,
    } ,
);

# некорректные миграции, должны отбраковываться
my @incorrect_tests = (
    {
        name => 'sql + missed "when" field',
        filename => 'file.migr',
        file => q%[
        {
            type => 'sql', 
            db => 'ppc',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        },
        {
            type => 'sql', 
            db => 'db2',
            when => 'after',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c2 int'
        },
        ]
        %,
    },
    {
        name => 'sql + missed "time_estimate" field',
        filename => 'file.migr',
        file => q%[
        {
            type => 'sql', 
            db => 'ppc',
            when => 'after',
            time_estimate => '3 сек.',
            sql => 'alter table t add column c int'
        },
        {
            type => 'sql', 
            db => 'db2',
            when => 'after',
            sql => 'alter table t add column c2 int'
        },
        ]
        %,
    },
);

for my $t (@correct_tests){
    my $migrations;
    lives_ok { 
        $migrations = Migrator::parse_migrations({$t->{filename}=> $t->{file}});
        my @errors = Migrator::extract_errors($migrations);
        die "errors:\n".join("\n", @errors)."\n" if @errors;
    } $t->{name};


    is(scalar @$migrations, 1, "$t->{name}-1");
    is(scalar @{$migrations->[0]->{tasks}}, $t->{task_count}, $t->{name});
}

for my $t (@incorrect_tests, @plaintext_tests){
    dies_ok{
        my $migrations = Migrator::parse_migrations({$t->{filename} => $t->{file}}, no_plaintext => 1);

        my @errors = Migrator::extract_errors($migrations);
        die "errors:\n".join("\n", @errors)."\n" if @errors;
    } $t->{name};
}

done_testing();
