#!/usr/bin/env perl

=head1 NAME

    directadmin-downtime-stat - статистика по тикето-обусловленным даунтаймам

=head1 SYNOPSIS

    directadmin-downtime-stat.pl > stat
    cat stat | sort -t$'\t' -k3,3 -k2,2 -k4,4 -k1,1 | column -s$'\t' -t

=head1 COMMANDS

=cut


use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);
use Data::Dumper;

use Startrek::Client::Easy;

my $st = Startrek::Client::Easy->new();

printf "%s\n", join "\t", qw(time host service ticket components);

for my $p (1 .. 100) {
    my $r = $st->get(query => qq(Queue: DIRECTADMIN and Components: juggler_downtime_guard "Sort By": created DESC), page => $p, perPage => 100);
    last if ! ref($r) eq 'LIST';
    for my $t (@$r) {
        next if ! $t->{key};
        #next if $t->{key} ne 'DIRECTADMIN-7056';

        my @events;
        push @events, parse_juggler_msg($t->{summary} // 'undef', $t->{createdAt});
        push @events, parse_juggler_msg($t->{description} // 'undef', $t->{createdAt});
        push @events, parse_juggler_comments($st, $t);

        push(@$_, $t->{key}, join ",", @{$t->{components}}) for (@events);

        printf("%s\n", join "\t", @$_) for @events;
    }
}

sub parse_juggler_comments {
    my ($st, $t) = @_;
    my $comments = $st->request('GET', "/issues/$t->{key}/comments");
    return () if ! ref($comments) eq 'LIST';

    my @events;
    for my $c (@$comments) {
        my $text = $c->{text} // 'undef';
        push @events, parse_juggler_msg($text, $c->{createdAt});
    }
    return @events;
}

sub parse_juggler_msg {
    my ($data, $time) = @_;
    my @data = split /\n/, $data;
    $time //= 'undef';
    $time =~ s/\..*$//;

    my @events;
    for (@data) {
        if (/([\w-]+\.(?:prod|test|dev)_[\w.-]+)\s*:\s*([\w-]+)/) {
            push @events, [$time, $1, $2] # host, service
        }
    }
    return @events;
}

