#!/usr/bin/env perl

=head1 NAME

    directmon-stat - статистика по звонкам из тикетов DIRECTMON

=head1 SYNOPSIS

    directmon-stat.pl > stat
    # 49096 - компонента no-action, то есть на мониторинг реагировать не пришлось
    cat stat | grep -vw OK | grep -w 49096 | sort -t$'\t' -k3,3 -k4,4 -k7,7 -k8,8 -k1,1 | column -s$'\t' -t

=head1 COMMANDS

=cut


use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);
use Data::Dumper;

use Startrek::Client::Easy;

my $st = Startrek::Client::Easy->new();

printf "%s\n", join "\t", qw(time status host service child_status child_host child_service ticket components);

for my $p (1 .. 100) {
    my $r = $st->get(query => qq(Queue: DIRECTMON and Resolution: notEmpty() and Components: directadmin.calls and Components: !false-positive "Sort By": created DESC), page => $p, perPage => 100);
    last if ! ref($r) eq 'LIST';
    for my $t (@$r) {
        next if ! $t->{key};
        #next if $t->{key} ne 'DIRECTMON-27';

        my @events;
        my $descr = $t->{description} // 'undef';
        push @events, parse_juggler_msg($descr);
        push @events, parse_juggler_comments($st, $t);

        push(@$_, $t->{key}, join ",", @{$t->{components}}) for (@events);

        printf("%s\n", join "\t", @$_) for @events;
    }
}

sub parse_juggler_comments {
    my ($st, $t) = @_;
    my $comments = $st->request('GET', "/issues/$t->{key}/comments");
    return () if ! ref($comments) eq 'LIST';

    my @events;
    for my $c (@$comments) {
        my $text = $c->{text} // 'undef';
        push @events, parse_juggler_msg($text);
    }
    return @events;
}

sub parse_juggler_msg {
    my $data = shift;
    my @data = split /\n/, $data;

    my @events;
    my (@aggr, $time, @child);
    for (@data) {
        if (!@aggr && /(CRIT|WARN|OK) on \S+ ([^:]+):([^)]+)/) {
            @aggr = ($1, $2, $3); # status, host, service
            next;
        }
        if (!$time && /At (\S+ \S+)/) {
            $time = $1;
            #$time =~ s/ /T/;
            next;
        }
        if (@aggr && $time && /\|\| *!!\(\w+\)(CRIT|WARN|OK)!! *\| *([^| ]+) *\| *([^| ]+)/) {
            push @events, [$time, @aggr, $1, $2, $3]; # child status, host, service
        }
    }
    return @events;
}

