#!/usr/bin/perl

=head1

> time ./dev/benchmark.pl
                          Rate var_x_1000 multilayer_9 var_through_subs_x_100 multilayer_4 multilayer_1
var_x_1000             13793/s         --          -5%                   -18%         -35%         -77%
multilayer_9           14514/s         5%           --                   -13%         -31%         -76%
var_through_subs_x_100 16779/s        22%          16%                     --         -21%         -72%
multilayer_4           21142/s        53%          46%                    26%           --         -64%
multilayer_1           59524/s       332%         310%                   255%         182%           --

./dev/benchmark.pl  24.58s user 2.23s system 99% cpu 26.828 total


=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use Benchmark;

use lib "$Bin";
use lib "$Bin/../lib";

use Settings;
use MultilayerConfig;

$MultilayerConfig::METADATA_FILE = "$Bin/metadata.yaml";
$MultilayerConfig::SOURCES = [
    "file:$Bin/conf_1.yaml",
    "file:$Bin/conf_2.yaml",
    "file:$Bin/conf_3.yaml",
    "file:$Bin/conf_4.yaml",
    "file:$Bin/conf_5_no_file.yaml",
    "file:$Bin/conf_6_no_file.yaml",
    "file:$Bin/conf_6_no_file.yaml",
    "file:$Bin/conf_8_no_file.yaml",
    "file:$Bin/conf_9.yaml",
];

my $N = 100_000;

sub var_x_1000 
{
    for (1 .. 1000){
        my $i = $Settings::IMAGE_HOST;
    }
}

sub value
{
    return 'some text';
}

sub f3
{
    return value();
}

sub f2
{
    return f3();
}

sub f1
{
    return f2();
}

sub var_through_subs_x_100
{
    for (1 .. 100){
        my $i = f1();
    }
}

sub multilayer_1
{
    my $i = get_param('PARAM_1');
}

sub multilayer_4
{
    my $i = get_param('PARAM_4');
}

sub multilayer_9
{
    my $i = get_param('PARAM_9');
}

Benchmark::cmpthese($N, {
        var_x_1000       => \&var_x_1000,
        var_through_subs_x_100 => \&var_through_subs_x_100,
        multilayer_1     => \&multilayer_1,
        multilayer_4     => \&multilayer_4,
        multilayer_9     => \&multilayer_9,
    });

