#!/usr/bin/perl

use strict;
use warnings;

use FindBin qw/$Bin/;

use Test::More;
use Test::Deep;
use Test::Exception;

use MultilayerConfig;

my %test_cases = (
    # хороший синтаксис
    good => [
        # нет переменных
        {
            value => 'some text',
            subst1 => {
            },
            subst2 => {
            },
            result => "some text",
        },

        # экранированные $
        {
            value => 'some text\${var}',
            subst1 => {
            },
            subst2 => {
            },
            result => 'some text\${var}',
        },
        {
            value => 'some text\$',
            subst1 => {
            },
            subst2 => {
            },
            result => 'some text\$',
        },
        {
            value => '\$some text',
            subst1 => {
            },
            subst2 => {
            },
            result => '\$some text',
        },
        {
            value => '\$some \$text\$',
            subst1 => {
            },
            subst2 => {
            },
            result => '\$some \$text\$',
        },
        {
            value => '\$\${var}some \$text\$',
            subst1 => {
            },
            subst2 => {
            },
            result => '\$\${var}some \$text\$',
        },

        # переменные


        # сочетание переменных и экранированных $


    ],

    # некорректный синтаксис
    bad => [
        {
            value => 'some text${var}',
            subst1 => {
            },
            subst2 => {
            },
        },
    ],
);

for my $case ( @{$test_cases{good}} ){
    my $value = $case->{value};
    MultilayerConfig::_substitute_templ_vars(\$value, $case->{subst1}, $case->{subs2});
    is( $value, $case->{result}, "substitution for '$case->{value}'" );
}

for my $case ( @{$test_cases{bad}} ){
    my $value = $case->{value};
    dies_ok { MultilayerConfig::_substitute_templ_vars(\$value, $case->{subst1}, $case->{subs2}) } "bad substitutions for '$case->{value}'";
}

done_testing();

