#!/usr/bin/perl

use strict;
use warnings;

use FindBin qw/$Bin/;

use Test::More;
use Test::Exception;

use MultilayerConfig;

# есть источники, нет метеданных

$MultilayerConfig::SOURCES = [
    "file:$Bin/data/metadata/conf_2.yaml",
    "file:$Bin/data/metadata/conf_1.yaml",
];

dies_ok { get_param('IMAGE_HOST') } 'no metadata -- get_param must die';

# несуществующий файл с метаданными

$MultilayerConfig::METADATA = [ "$Bin/data/metadata/metadataaaa.yaml" ];

dies_ok { get_param('IMAGE_HOST') } 'nonexistent metadata -- get_param must die';

# правильный файл с метаданными

$MultilayerConfig::METADATA = [ "$Bin/data/metadata/metadata.yaml" ];

is(get_param('IMAGE_HOST'), 'metadata/IMAGE_HOST_value_from_conf_1');
is(get_param('IMAGE_HOST_RO'), 'metadata/IMAGE_HOST_RO_value_from_conf_1');
dies_ok { get_param('IMAGE_HOST_RW') } 'metadata doesnt allow this param';

# снова несуществующий файл с метаданными

$MultilayerConfig::METADATA = [ "$Bin/data/metadata/metadataaaa.yaml" ];

dies_ok { get_param('IMAGE_HOST') } 'new nonexistent metadata -- get_param must die';
dies_ok { get_param('SOME_PARAM') } 'new nonexistent metadata -- get_param must die';

# новый правильный файл с метаданными

$MultilayerConfig::METADATA = [ "$Bin/data/metadata/metadata2.yaml" ];

is(get_param('IMAGE_HOST'), 'metadata/IMAGE_HOST_value_from_conf_1');
dies_ok { get_param('IMAGE_HOST_RO') } 'new metadata doesnt allow this param';
lives_ok { get_param('IMAGE_HOST_RW') } 'new metadata  does allow this param';

# снова старый файл с метаданными

$MultilayerConfig::METADATA = [ "$Bin/data/metadata/metadata.yaml" ];

is(get_param('IMAGE_HOST'), 'metadata/IMAGE_HOST_value_from_conf_1');
is(get_param('IMAGE_HOST_RO'), 'metadata/IMAGE_HOST_RO_value_from_conf_1');
dies_ok { get_param('IMAGE_HOST_RW') } 'metadata doesnt allow this param';

done_testing();

