#!/usr/bin/perl

use strict;
use warnings;

use FindBin qw/$Bin/;

use Test::More;

use MultilayerConfig;

$MultilayerConfig::METADATA = [ "$Bin/data/simple-config/metadata.yaml" ];

$MultilayerConfig::SOURCES = [
    "file:$Bin/data/simple-config/conf_2.yaml",
    "file:$Bin/data/simple-config/conf_1.yaml",
];

is(get_param('IMAGE_HOST'), 'simple-config/IMAGE_HOST_value_from_conf_1');
is(get_param('IMAGE_HOST_RO'), 'simple-config/IMAGE_HOST_RO_value_from_conf_1');

$MultilayerConfig::SOURCES = [
    "file:$Bin/data/simple-config/conf_1.yaml",
    "file:$Bin/data/simple-config/conf_2.yaml",
];

is(get_param('IMAGE_HOST'), 'simple-config/IMAGE_HOST_value_from_conf_2');
is(get_param('IMAGE_HOST_RO'), 'simple-config/IMAGE_HOST_RO_value_from_conf_1');

done_testing();

