#!/usr/bin/perl

use strict;
use warnings;

use FindBin qw/$Bin/;

use Test::More;
use Test::Exception;

use MultilayerConfig;

# нет источников, нет метаданных 

dies_ok { get_param('IMAGE_HOST') } 'no metadata -- get_param must die';

# есть источники, нет метеданных

$MultilayerConfig::SOURCES = [
    "file:$Bin/data/sources/conf_2.yaml",
    "file:$Bin/data/sources/conf_1.yaml",
];

dies_ok { get_param('IMAGE_HOST') } 'no metadata -- get_param must die';

# есть метаданные, нет источников

$MultilayerConfig::METADATA = [ "$Bin/data/sources/metadata.yaml" ] ;

$MultilayerConfig::SOURCES = [ ];

dies_ok { get_param('IMAGE_HOST') } 'there is no such param in sources';

dies_ok { get_param('WRONG_PARAM') } 'not in metadata';

# источник неизвестного типа

$MultilayerConfig::SOURCES = [
    "notype:something",
];

dies_ok { get_param('IMAGE_HOST_RW') };

# один правильный источник

$MultilayerConfig::SOURCES = [
    "file:$Bin/data/sources/conf_1.yaml",
];

is(get_param('IMAGE_HOST'), 'sources/IMAGE_HOST_value_from_conf_1');

dies_ok { get_param('IMAGE_HOST_RW') };


# источник типа glob
$MultilayerConfig::SOURCES = [
    "file:$Bin/data/sources/conf_2.yaml",
    "glob:$Bin/data/sources/conf_override*.yaml",
];

is(get_param('IMAGE_HOST'), 'sources/IMAGE_HOST_value_from_conf_override_1');
is(get_param('IMAGE_HOST_RO'), 'sources/IMAGE_HOST_RO_value_from_conf_override_2');
is(get_param('IMAGE_HOST_RW'), 'sources/IMAGE_HOST_RW_value_from_conf_2');

# источник - %ENV

$MultilayerConfig::SOURCES = [
    "ENV:MULTI_CONFIG_",
];

dies_ok { get_param('IMAGE_HOST') };

$ENV{MULTI_CONFIG_IMAGE_HOST} = 'text from %ENV';
is(get_param('IMAGE_HOST'), 'text from %ENV');

$ENV{MULTI_CONFIG_WRONG_PARAM} = 'text from %ENV';
dies_ok { get_param('WRONG_PARAM') };

delete $ENV{MULTI_CONFIG_IMAGE_HOST};
delete $ENV{MULTI_CONFIG_WRONG_PARAM};

# несуществующие файлы в источниках

$MultilayerConfig::SOURCES = [
    "file:$Bin/data/sources/conf_no_file_1.yaml",
    "file:$Bin/data/sources/conf_no_file_2.yaml",
    "file:$Bin/data/sources/conf_1.yaml",
    "file:$Bin/data/sources/conf_no_file_3.yaml",
];

for my $i (0, 1, 3){
    ok( ! -f $MultilayerConfig::SOURCES->[$i] =~ s/^file://r, "source $MultilayerConfig::SOURCES->[$i] should not exist" );
}
ok( -f $MultilayerConfig::SOURCES->[2] =~ s/^file://r, "source $MultilayerConfig::SOURCES->[2] should exist" );

is(get_param('IMAGE_HOST'), 'sources/IMAGE_HOST_value_from_conf_1');

dies_ok { get_param('IMAGE_HOST_RW') };

# все вместе 

$MultilayerConfig::SOURCES = [
    "file:$Bin/data/sources/conf_2.yaml",
    "glob:$Bin/data/sources/conf_override*.yaml",
    "ENV:MULTI_CONFIG_",
];

is(get_param('IMAGE_HOST'), 'sources/IMAGE_HOST_value_from_conf_override_1');
is(get_param('IMAGE_HOST_RO'), 'sources/IMAGE_HOST_RO_value_from_conf_override_2');
is(get_param('IMAGE_HOST_RW'), 'sources/IMAGE_HOST_RW_value_from_conf_2');

$ENV{MULTI_CONFIG_IMAGE_HOST} = 'another text from %ENV';
is(get_param('IMAGE_HOST'), 'another text from %ENV');

is(get_param('IMAGE_HOST_RO'), 'sources/IMAGE_HOST_RO_value_from_conf_override_2');
is(get_param('IMAGE_HOST_RW'), 'sources/IMAGE_HOST_RW_value_from_conf_2');


done_testing();

