#!/bin/bash
# функциональность претендует на то, чтобы отделить её от бэкапов, но пока реализация не очень надёжная, не распространяем её
# более надёжная реализация могла бы использовать код от переключалки мастера

instance="$1"
if expr "$instance" : ppcdata >/dev/null; then
    master_fqdn=$(</etc/yandex-direct/db-config.json jq -r '.db_config.CHILDS.ppc.CHILDS[] | select(.instance == $instance) | .host' --arg instance "$instance")
elif [ "$instance" = ppcmonitor ]; then
    master_fqdn=$(</etc/yandex-direct/db-config.json jq -r '.db_config.CHILDS.monitor.host')
elif [ "$instance" = ppcdict ]; then
    master_fqdn=$(</etc/yandex-direct/db-config.json jq -r '.db_config.CHILDS.ppcdict.host') 
elif [ "$instance" = sandbox ]; then
    master_fqdn=$(</etc/yandex-direct/sandbox-db-config.json jq -r '.db_config.host')
else
    printf "error: unsupported instance: '%s'\n" "$instance" >&2
    exit 1
fi
printf "%s" "$master_fqdn"
