#!/bin/bash

fqdn=$(hostname --fqdn)
for instance in $(/usr/local/bin/lm --complete); do
    master_fqdn=$(/usr/bin/get-master-fqdn-for-backup.sh "$instance")
    if [ -z "$master_fqdn" ]; then
        printf "could not get master fqdn for instance '%s', skipping\n" "$instance" >&2
        continue
    fi
    if [ "$fqdn" == "$master_fqdn" ]; then
        pgrep -a -f "(^| |/)mysql-backup-mds( | .* )create( | .* )$instance\>" >&2 || printf "nothing to kill for instance '%s'\n" "$instance" >&2
        pkill -f "(^| |/)mysql-backup-mds( | .* )create( | .* )$instance\>"
    fi
done
