#!/usr/bin/env python2
# -*- encoding: utf-8 -*-

import boto2
import logging

def list_buckets(dbh, **kwargs):
    buckets_all = [i.name for i in dbh.get_all_buckets()]
    backup_bucket_names = kwargs.get('bucket_names', None)
    if backup_bucket_names:
        buckets_found = list(set(backup_bucket_names) & set(buckets_all))
    else:
        buckets_found = buckets_all
    if len(buckets_found) == 0:
        return (1, 'Not found buckets for filter'.format(backup_bucket_names))
    return (0, buckets_found)

