#!/usr/bin/env python2

from boto.s3.connection import S3Connection

def connect(**kwargs):
     address = kwargs.get('address')
     access_key = kwargs.get('access_key')
     secret_key = kwargs.get('secret_key')
     dbh = S3Connection(host=address, 
			 aws_access_key_id=access_key, 
                         aws_secret_access_key=secret_key
			)
     return dbh

def list_buckets(**kwargs):
    dbh = kwargs.get('dbh')
    bucket = kwargs.get('find', None)
    return [i.name for i in dbh.get_all_buckets()]

def find_bucket(**kwargs):
    all_buckets = list_buckets(**kwargs)
    name = kwargs.get('find')
    finded = name in all_buckets
    return finded

def list_keys(**kwargs):
    bucket = get_bucket(**kwargs)
    return [ i.name for p in kwargs.get('prefix_list', '') for i in bucket.get_all_keys(prefix=p) ] #max count S3 list=1000

def size_keys(**kwargs):
    bucket = get_bucket(**kwargs)
    return dict([ (i.name, i.size)  for p in kwargs.get('prefix_list', '') for i in bucket.get_all_keys(prefix=p) ])

def create_bucket(**kwargs):
    dbh = kwargs.get('dbh')
    name = kwargs.get('name_bucket')
    return dbh.create_bucket(name)

def get_bucket(**kwargs):
    dbh = kwargs.get('dbh')
    name = kwargs.get('name_bucket')
    return dbh.get_bucket(name)

def list_uploads(**kwargs):
    bucket = get_bucket(**kwargs)
    return [ i.key_name for i in bucket.get_all_multipart_uploads() ]

def clean_uploads(**kwargs):
    bucket = get_bucket(**kwargs)
    prefix = kwargs.get('prefix', '')
    suffix = kwargs.get('suffix', '')
    deleted = []
    for i in bucket.get_all_multipart_uploads():
        name = i.key_name
        if not name.startswith(prefix): continue
        if not name.endswith(suffix): continue
        i.cancel_upload()
        deleted.append(name)
    return deleted

def set_bucket(**kwargs):
    name = kwargs.get('name_bucket')
    exists = find_bucket(find=name, **kwargs)
    if exists:
        return get_bucket(**kwargs)
    return create_bucket(**kwargs)
