#!/bin/sh

if [ $(cat /etc/yandex/environment.type) == "production" ]; then
    export DBCONFIG="/etc/yandex-direct/db-config.json"
else
    export DBCONFIG="/etc/yandex-direct/db-config-np/db-config.test.json"
fi

while true; do
    for service_dir in /etc/service/ptkill.ppcdata*.operator=*; do
        if [ ! -d "$service_dir" ]; then
            break
        fi
        old_dir=`pwd`
        cd "$service_dir"
        shard=`printf %s "$service_dir" | grep -oE 'ppcdata[0-9]+' | sed 's/ppcdata//'`
        if grep -q '^run$' supervise/stat; then
            master_host_for_process=`cat master_host`
            actual_master_host=`jq -r ".db_config.CHILDS.ppc.CHILDS[\"$shard\"].host" < "$DBCONFIG"`
            if [ "$master_host_for_process" != "$actual_master_host" ]; then
                printf '%s mysql master for shard %d changed from %s to %s, restarting service %s\n' `date -Iseconds` "$shard" "$master_host_for_process" "$actual_master_host" "$service_dir" >> /var/log/yandex/ptkill-for-operator.watcher.log
                /usr/bin/sv restart "$service_dir"
            fi
        fi
        cd "$old_dir"
    done
    sleep 10
done
