#!/bin/sh -e

if [ $(cat /etc/yandex/environment.type) == "production" ]; then
	export DBCONFIG="/etc/yandex-direct/db-config.json"
    pwd_file=/etc/direct-tokens/mysql_ppc
    mysql_user=ppc
else
	export DBCONFIG="/etc/yandex-direct/db-config-np/db-config.test.json"
    pwd_file=/etc/direct-tokens/mysql_direct-test
    mysql_user=direct-test
fi	

service_name=$(basename "$(pwd)")
if printf %s "$service_name" | grep -q '^pt-kill\.ppcdata[0-9]\+\.operator=[0-9]\+$'; then
    printf "unexpected pt-kill service name, exiting: %s\n" "$service_name" >&2
    exit 1
fi

shard=$(printf %s "$service_name" | grep -o 'ppcdata[0-9]\+' | sed s/ppcdata//)
operator_uid=$(printf %s "$service_name" | grep -o 'operator=[0-9]\+' | sed s/operator=//)

if [ -f PT_KILL_LEAVE_ALIVE ]; then
    PT_KILL_LEAVE_ALIVE=$(cat PT_KILL_LEAVE_ALIVE)
fi
if [ -z "$PT_KILL_LEAVE_ALIVE" ]; then
    PT_KILL_LEAVE_ALIVE=50
fi
export PT_KILL_LEAVE_ALIVE
if [ -f pt-kill_query-count ]; then
    query_count=$(cat pt-kill_query-count)
fi
if [ -f pt-kill_interval ]; then
    interval=$(cat pt-kill_interval)
fi

master_host=$(jq -r ".db_config.CHILDS.ppc.CHILDS[\"$shard\"].host" < "$DBCONFIG")
printf %s "$master_host" > master_host  # для наблюдения

exec /usr/bin/pt-kill2 --host "$master_host" -D ppc --password "$(cat $pwd_file)" --match-info "operator=$operator_uid" --user "$mysql_user" --shard-name "ppcdata${shard}" --interval "${interval:-10}" --query-count "${query_count:-100}" --victims all --print --kill >> "/var/log/yandex//mysql-ptkill2.ppcdata$shard.operator=$operator_uid.log"
