#!/bin/bash -e

# Клонирует живую реплику mysql 

# !!! ATTENTION !!!
# 1. Скрипт пока в стадии proof-of-concept прототипа, пользоваться с осторожностью. 
# 2. Отлаживался и использовался только на ppcdata*, к другим БД применимость под вопросом.
# 3. Не ограничивает скорость передачи архива, с мастера в таком виде забирать данные нельзя

# Как пользоваться:
# 1. подготовиться, начало инструкции https://wiki.yandex-team.ru/jeri/innobackupex/ 
#   - tmux
#   - пакеты (новое! mbuffer)
#   - удалить старые файлы
#   - создать каталог для data
#   - проверить, что в /tmp есть место для копии архива

# 2. запустить скрипт с с параметром-источником:
# dt-replica-clone.sh ppcdata14-01e.yandex.ru

# 3. вручную сделать change-master; скрипт пробует подсказать все параметры кроме мастера

# Если хочется наливку с мастера -- надо в mbuffer на источнике добавить ограничение (параметр -r)

#================================================================================================


# TODO поставить / проверить mbuffer

set -x

set -o pipefail

export SOURCE_HOST=$1

# TODO сравнить версии всего
# TODO посчитать, достаточно ли места под копию бекапа

export PPCDATA=`lm --complete|head -n 1`

echo copying $PPCDATA from $SOURCE_HOST

ssh $SOURCE_HOST 'dpkg -l percona-xtrabackup-24 qpress yandex-du-lm'
dpkg -l percona-xtrabackup-24 qpress yandex-du-lm

# TODO lm ppcdata0 server-stop -f

cd /opt/mysql.$PPCDATA/data

# проверить, что ничего не осталось либо удалить
#files=`ls -R . |grep -v '^bin-logs$' |grep -v '^relay-logs$'`

rplcat_passwd=`ssh -q root@$SOURCE_HOST "head -n 6 /opt/mysql.$PPCDATA/data/master.info |tail -n 1"`
master_port=`ssh -q root@$SOURCE_HOST "head -n 7 /opt/mysql.$PPCDATA/data/master.info |tail -n 1"`

echo $rplcat_passwd $master_port . 
#exit

sleep 10

# можем ли сразу складывать архив в /tmp, и разархивировать (decompress) уже оттуда?

set +x
time ssh -q root@$SOURCE_HOST <<'EOF' "PPCDATA='$PPCDATA' bash -s" | mbuffer -q | xbstream -x -v
    set -o pipefail
    cd /opt/mysql.$PPCDATA/data
    innobackupex --defaults-file=/etc/mysql/$PPCDATA.cnf --socket=/var/run/mysqld.$PPCDATA/mysqld.sock --user=root --stream=xbstream --compress --compress-threads=8 --parallel=2 --binlog-info=ON --slave-info --safe-slave-backup ./ |mbuffer -q
EOF
set -x

cp -r . /tmp/$PPCDATA-data
time innobackupex --decompress --parallel 16 .
find . -name '*.qp' -delete
innobackupex --apply-log --use-memory=96G .
chown mysql: -R /opt/mysql.$PPCDATA
lm $PPCDATA fix-uuid -f 
lm $PPCDATA server-start --skip-slave-start -f
lm $PPCDATA status-gtid

gtid_exec=$(cat xtrabackup_binlog_info | perl -pe 's/\n//' | awk '{ print $NF }')
lm $PPCDATA mysql "reset master; set global gtid_purged='$gtid_exec'"


cat <<EOF



TODO: lm $PPCDATA change-master <...>.yandex.ru:$master_port:auto:auto:rplcat:$rplcat_passwd
EOF

