#!/usr/bin/python
# -*- coding: utf8 -*-

import unittest
import os.path
import sys
dr = os.path.dirname(__file__)
sys.path.append(os.path.join(dr, '..', 'bin'))
import importlib
import json
mysql_gtid_consistency = importlib.import_module('mysql_gtid_consistency')


def get_subtests(f):
    with open(f, 'r') as f:
        return json.load(f)


class TestCmp(unittest.TestCase):
    def test_cmp(self):
        subtests = get_subtests(dr+'/cmp_tests.json')
        for test in subtests:
            self.assertEqual(mysql_gtid_consistency.find_errors([(host, test['gtids'][host]) for host in test['gtids']], test['master_uuid'], {})[0], test['expected'])


if __name__ == '__main__':
    unittest.main()

