# -*- coding: utf-8 -*-

import sys
import os
import datetime
import time
import dateutil.parser
import logging
from kazoo.client import KazooClient

ZK_HOSTS = "ppcback01f.yandex.ru,ppcback01e.yandex.ru,ppcback01i.yandex.ru"
ZK_TIMEOUT = 10
ZK_RETRY = {"max_tries": 1, "delay": 1, "max_jitter": 1, "backoff": 1, "ignore_expire": False}
zkh = KazooClient(hosts=ZK_HOSTS, timeout=ZK_TIMEOUT, connection_retry=ZK_RETRY, command_retry=ZK_RETRY)

ZK_LOCATION = "/direct/hosts-downtimes"
LOCK_NAME = "lock"
LOCK_LOCATION = "%s/%s" % (ZK_LOCATION, LOCK_NAME)
RELAX_TIME = 5
DELIM = "|"


def parse_node(zk_path):
    return [
        tuple((line + ("" if line.find(DELIM) != -1 else DELIM)).split(DELIM, 1))
        for line in zkh.get(zk_path)[0].decode('utf-8').split("\n")
    ]


def build_node_content(downtimes):
    return "\n".join(
        DELIM.join(item) for item in sorted(downtimes, key=lambda x: (dateutil.parser.parse(x[0]), x[1]))
    ).encode('utf-8')


def send_data_to_zk(hosts, event_datetime, info=''):
    for host in hosts:
        zk_path = "%s/%s" % (ZK_LOCATION, host)
        if zkh.exists(zk_path):
            zkh.set(zk_path, build_node_content(set(parse_node(zk_path) + [(str(event_datetime), info)])))
        else:
            zkh.create(zk_path, build_node_content([(str(event_datetime), info)]))


def get_lock():
    author = "author=%s" % os.path.basename(sys.argv[0])
    while True:
        try:
            zkh.create(LOCK_LOCATION, "%s\ntime=%s" % (author, str(datetime.datetime.now())), ephemeral=True)
            break
        except:
            logging.info("can't get lock, waiting for %d seconds..." % RELAX_TIME)
            time.sleep(RELAX_TIME)

