#!/usr/bin/perl

use strict;
use warnings;

use my_inc '/var/www/beta.lena-san.8880', for => 'protected';

use List::MoreUtils qw/any uniq firstval/;
use YAML;

use Yandex::TimeCommon;

use E;
use User;
use GeoTools;

use utf8;
use open ":std" => ":utf8";

run() unless caller();


sub run
{
    my $vars = {};
    my $ag_uids = rbac_get_all_agencies($rbac) || [];
    my $agencies_data = get_users_data($ag_uids, [qw/uid email valid LastChange fio phone sendNews sendWarn createtime
            ClientID login hidden sendAccNews not_resident statusArch statusBlocked
            description lang captcha_freq allowed_ips statusYandexAdv showOnYandexOnly geo_id/]);
    # В RBAC есть агентства, отсутствующие в users. отсекаем таких.
    $vars->{agencies} = [grep { $_->{uid} } values %$agencies_data];

    my $manager_uid_by_agency_uid = RBACDirect::rbac_mass_get_manager_of_agencies($rbac, [map { $_->{uid} } @{ $vars->{agencies} }]);
    # Менеджеры агентств тоже не все находятся.
    my $managers_data = get_users_data([uniq grep { defined $_ } values %$manager_uid_by_agency_uid], [qw/login fio/]);

    for my $agency_info (@{ $vars->{agencies} }) {
        $agency_info->{createtime_text} = unix2human($agency_info->{createtime}, "%Y-%m-%d");
        if (my $manager_uid = $manager_uid_by_agency_uid->{ $agency_info->{uid} }) {
            $agency_info->{manager_login} = $managers_data->{$manager_uid}->{login};
            $agency_info->{manager_fio} = $managers_data->{$manager_uid}->{fio};
        } else {
            $agency_info->{manager_login} = undef;
            $agency_info->{manager_fio} = undef;
        }
    }

    my @recent = grep { $_->{createtime_text} ge "2015-10-01" } @{$vars->{agencies}};

    #print YAML::Dump($vars);
    my @fields = qw/login fio email agency_rep_type city manager_login manager_fio/;
    print join ";", @fields;
    print "\n";
    for my $ag (@recent){
        $ag->{city} = get_cityname_by_geoid($ag->{geo_id});
        my $misc = get_agency_client_vars($rbac, $ag->{uid});
        $ag->{agency_rep_type} = { limited => "по работе с клиентами", chief => "главный", main => "представитель" }->{$misc->{agency_rep_type}};
        print join ";", map { $ag->{$_} || '' } @fields;
        print "\n";
    }

}

