#!/usr/bin/env perl

use Direct::Modern;

use my_inc '.', for => 'protected';

use DScribe::Grep::Clickhouse::Direct;

use E;
use Time::Piece;

my $grep_class = 'DScribe::Grep::Clickhouse::Direct';
open F2, '>:crlf', 'log.txt';

sub my_prewhere {
    my $t = localtime;
    my $to_dt = $t->ymd;
    my $f = $t - 86_400 * 183; # последнее — это количество дней
    my $from_dt = $f->ymd;

    return join ' AND ', sprintf("log_date >= toDate('%s')", $from_dt), sprintf("log_date <= toDate('%s')", $to_dt);
}

sub my_build_query {
    my ($self, $opt) = @_;
    my @query;
    my $prewhere = my_prewhere();
    push @query,
        'SELECT' => 'uid, argMax(ip, log_date) as ip_address, max(log_date) as max_log_date',
        'FROM' => $self->table_name,
        ($prewhere ? (prewhere => $prewhere) : ()),
        where => (join ' AND ', @{$self->additional_sql}),
        'GROUP BY' => "uid",
        $self->limit_sql,
        'FORMAT JSON';
    return join "\n", @query;
}

sub my_grep_logs {
    my ($self) = @_;

    my $query = my_build_query($self, {});
    $self->query($query);
    if ($self->verbose) {
        print F2 "$query\n";
    }
    my $res = $self->clickhouse->query($query);
    return $res->json()->{data};
}

open F, '>:crlf', 'client_id_uid_ip_address';

my $maximum_uid = get_one_field_sql(PPCDICT, "select max(uid) from shard_uid");
say F2 "maximum uid is $maximum_uid, let's ask clickhouse about everyone";

my $grep_cmd = $grep_class->new('ppclog_cmd', limit => $maximum_uid);
$grep_cmd->add_sql_condition(("uid <= $maximum_uid and uid > 0"));
my $grep_api = $grep_class->new('ppclog_api', limit => $maximum_uid);
$grep_api->add_sql_condition(("uid <= $maximum_uid and uid > 0"));
my $data_cmd;
eval {$data_cmd = my_grep_logs($grep_cmd)};
if ($@) {
    say F2 "failed for log_cmd, $@";
    close F;
    close F2;
    exit;
}
my $data_api;
eval {$data_api = my_grep_logs($grep_api)};
if ($@) {
    say F2 "failed for log_api, $@";
    close F;
    close F2;
    exit;
}
if ((ref $data_cmd && @$data_cmd) && (ref $data_api && @$data_api)) {
    my %uid2record;
    foreach my $record (@$data_cmd) {
        $uid2record{$record->{uid}} = {
            ip_address => $record->{ip_address},
            log_date => $record->{max_log_date}
        };
    }

    foreach my $record (@$data_cmd) {
        if (!exists $uid2record{$record->{uid}} || $uid2record{$record->{uid}}->{log_date} lt $record->{max_log_date}) {
            $uid2record{$record->{uid}} = {
                ip_address => $record->{ip_address},
                log_date => $record->{max_log_date}
            };
        }
    }
    undef $grep_api;
    undef $grep_cmd;
    undef $data_api;
    undef $data_cmd;

    foreach my $shard (1..$Settings::SHARDS_NUM) {
        say F2 "requesting data for shard $shard";
        my $uid2clientid = get_hash_sql(PPC_HEAVY(shard => $shard),
            "select u2.uid, clientid
            from clients natural join users left join campaigns using (uid) left join users u2 using (clientid)
            where agencyuid is null and manageruid is null and cid is not null and clientid > 0
            group by clientid, u2.uid"
        ); # собрали всех самоходных клиентов, у которых есть кампании, и каждому приписали всех его представителей
        my $ordered_buffer; # чтобы упорядочить по clientid
        foreach my $uid (sort {$a <=> $b} keys %$uid2clientid) {
            if (exists $uid2record{$uid}) {
                push @{$ordered_buffer->{$uid2clientid->{$uid}}},
                    {uid => $uid, ip_address => $uid2record{$uid}->{ip_address}, log_date => $uid2record{$uid}->{log_date}};
            }
        }

        foreach my $client_id (sort {$a <=> $b} keys %$ordered_buffer) {
            foreach my $record (@{$ordered_buffer->{$client_id}}) {
                say F join "\t", $client_id, $record->{uid}, $record->{log_date}, $record->{ip_address};
            }
        }
    }
}

close F;
close F2;
