#!/usr/bin/perl
use strict;
use warnings;
use 5.010;

BEGIN {
    no warnings 'once';
    $Settings::NO_SETTINGS_LOCAL = 1;
}

## ulimit -S -v 30000000

use Encode 'encode_utf8';
use FindBin '$Bin';

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::Shell;

use my_inc '/var/www/ppc.yandex.ru', for => 'protected';

use Settings;

yash_system( 'mkdir', '-p', "$Bin/banner_hrefs" );
yash_system( 'mkdir', '-p', "$Bin/logs" );

$Yandex::Log::LOG_ROOT = "$Bin/logs";

open my $uids_fh, '<', "$Bin/unique_cluids";

my @uids = <$uids_fh>;
chomp $_ for @uids;

my $handled_uids = 0;
my $chunk_num = 1;
foreach_shard uid => \@uids, chunk_size => 100, sub {
    my ( $shard, $uids_chunk ) = @_;

    my $rows = get_all_sql( PPC( shard => $shard ), [
        'SELECT banners.bid, banners.href, banners.domain FROM banners INNER JOIN campaigns USING(cid)',
        WHERE => { 'campaigns.uid' => $uids_chunk },
    ] );

    open my $out_fh, '>', sprintf( "$Bin/banner_hrefs/%03d", $chunk_num );
    for my $row (@$rows) {
        my ( $bid, $href, $domain ) = @$row{ qw( bid href domain ) };
        $href //= '';
        $domain //= '';
        print $out_fh encode_utf8("$bid\t$href\t$domain\n");
    }
    close $out_fh;

    $chunk_num++;
    $handled_uids += scalar(@$uids_chunk);

    say "handled_uids = $handled_uids / " . scalar(@uids);
};
