#!/usr/bin/perl
use strict;
use warnings;
use 5.010;

BEGIN {
    no warnings 'once';
    $Settings::NO_SETTINGS_LOCAL = 1;
}

## ulimit -S -v 30000000

use Encode 'encode_utf8';
use FindBin '$Bin';

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::Shell;

use my_inc '/var/www/ppc.yandex.ru', for => 'protected';

use Settings;

yash_system( 'mkdir', '-p', "$Bin/banner_hrefs_by_bids" );
yash_system( 'mkdir', '-p', "$Bin/logs" );

$Yandex::Log::LOG_ROOT = "$Bin/logs";

open my $bids_fh, '<', "$Bin/bids.out";

my @bids = <$bids_fh>;
chomp $_ for @bids;

my $handled_bids = 0;
my $chunk_num = 1;
foreach_shard bid => \@bids, chunk_size => 10_000, sub {
    my ( $shard, $bids_chunk ) = @_;

    my $rows = get_all_sql( PPC( shard => $shard ), [
        'SELECT bid, href, domain FROM banners',
        WHERE => { bid => $bids_chunk },
    ] );

    open my $out_fh, '>', sprintf( "$Bin/banner_hrefs_by_bids/%03d", $chunk_num );
    for my $row (@$rows) {
        my ( $bid, $href, $domain ) = @$row{ qw( bid href domain ) };
        $href //= '';
        $domain //= '';
        print $out_fh encode_utf8("$bid\t$href\t$domain\n");
    }
    close $out_fh;

    $chunk_num++;
    $handled_bids += scalar(@$bids_chunk);

    say "handled_bids = $handled_bids / " . scalar(@bids);
};
