#!/usr/bin/perl

=head2 DESCRIPTION

    Скрипт предназначен для "первого прохода" по файлу со всеми баннерами из БК:
    в результате один файл делится на два - те баннеры, у которых есть пара по BannerID в директе (good) и те - у которых пары нет (bad)

=cut

use warnings;
use strict;

use threads;

use DDP;
use List::Util qw/pairs/;

use Yandex::HashUtils;
use Yandex::DBTools;
use Yandex::Log;
$Yandex::Log::LOG_ROOT = '/home/ppalex/logs/';

# Статистика, настройки
use my_inc '/home/ppalex/trunk', for => 'protected';
use SettingsALL;
INIT { $Settings::LOCK_ROOT = '/home/ppalex/tmp'; }
use ScriptHelper;
use ShardingTools;

$Yandex::DBTools::QUERIES_LOG = undef;
$ScriptHelper::is_beta = 1;

use constant SELECT_CHUNK_SIZE => 40_000;

{
    # Yandex::Trace оказался не thread-safety
    no warnings 'redefine';
    sub _fake_new_profile { return; }
    *Yandex::Trace::new_profile = \&_fake_new_profile;
    sub _fake_current_span_id { return 'ppalex DIRECT-42261'; }
    *Yandex::Trace::current_span_id = \&_fake_current_span_id;
}

$log->out('START');

#   BannerID    ExportID    GroupExportId   EngineID    BaseNO
open (my $fh, '<', '/home/ppalex/tmp/DIRECT-42261-without_perf_and_dyn_childs-banners.txt') or $log->die("error opening input file: $!");
open (my $good, '>', '/home/ppalex/tmp/DIRECT-42261-without_perf_and_dyn_childs-AllGoodBanners.tsv') or $log->die("error opening output file: $!");
open (my $bad, '>', '/home/ppalex/tmp/DIRECT-42261-without_perf_and_dyn_childs-AllBadBanners.tsv') or $log->die("error opening output file: $!");

my %banners;
sub check {
    my $bids  = shift;

    # вариант без тредов, работает в 1,7 раз медленнее
    # my $sth = exec_sql(PRODUCTION_PPC_BSHEAVY(shard => 'all'), [
    #     'SELECT BannerID, "banner" FROM banners',
    #     where => { BannerID__int => $bids },
    #     'UNION SELECT BannerID, "picture" FROM banner_images',
    #     where => { BannerID__int => $bids },
    #     'UNION SELECT BannerID, "media" FROM media_banners',
    #     where => { BannerID__int => $bids },
    # ]);

    # while (my ($ID, $type) = $sth->fetchrow_array) {
    #     $banners{$ID}->{type} = $type;
    # }
    # $sth->finish;

    my @threads;
    for my $shard (reverse ppc_shards()) {
        push @threads, threads->create(
            {'context' => 'list'},
            sub {
                my @result;
                my $sth = exec_sql(PRODUCTION_PPC_BSHEAVY(shard => $shard), [
                    'SELECT BannerID, "banner" FROM banners',
                    where => { BannerID__int => $bids },
                    'UNION SELECT BannerID, "picture" FROM banner_images',
                    where => { BannerID__int => $bids },
                    'UNION SELECT BannerID, "media" FROM media_banners',
                    where => { BannerID__int => $bids },
                ]);

                while (my @row = $sth->fetchrow_array) {
                    push @result, @row
                }
                $sth->finish;
                return (@result);
            },
        );
    }
    for my $pair (pairs map { $_->join() } @threads) {
        $banners{$pair->[0]}->{type} = $pair->[1];
    }

    while (my ($ID, $data) = each %banners) {
        if (exists ($data->{type})) {
            print { $good } join ("\t", @{ $data }{ qw/BannerID bid pid EngineID BaseNO type/ } ), "\n";
        } else {
            print { $bad } join ("\t", @{ $data }{ qw/BannerID bid pid EngineID BaseNO/ } ), "\n";
        }
    }
}


my $i = 1;
my $cnt = 0;
while (<$fh>) {
    if (my $reason = smart_check_stop_file()) {
        $log->out($reason);
        last;
    }

    chomp;
    next unless $_ =~ m/^[0-9]/;
    my ($BannerID, $bid, $pid, $EngineID, $BaseNO) = split qr/\t/;
    unless ($BannerID) {
        $log->out("No BannerID!");
        next;
    }
    next unless ($EngineID == 7 || $EngineID == 77);

    $banners{$BannerID} = {
        bid         => $bid,
        BannerID    => $BannerID,
        pid         => $pid,
        EngineID    => $EngineID,
        BaseNO      => $BaseNO,
    };
    ++$cnt;

    if ($i == SELECT_CHUNK_SIZE) {
        check([keys %banners]);
        $i = 1;
        %banners = ();
        $log->out("processed row $cnt");
    } else {
        ++$i;
    }
}

check([keys %banners]);

close ($fh);
close ($good);
close ($bad);

$log->out('FINISH');
