#!/usr/bin/perl

=head2 DESCRIPTION

    Скрипт предназначен для "второго прохода" - по плохому файлу от первого прохода.
    Цель скрипта - попытаться по ExportID найти в директе пару (detail) или констатировать, что в директе баннера нет (unexist).
    информация исключительно справочная, в БК нужно сдавать предыдущий результат.

=cut

use warnings;
use strict;

use DDP;

use Yandex::HashUtils;
use Yandex::DBTools;
use Yandex::Log;
$Yandex::Log::LOG_ROOT = '/home/ppalex/logs/';

# Статистика, настройки
use my_inc '/home/ppalex/trunk', for => 'protected';
use SettingsALL;
INIT { $Settings::LOCK_ROOT = '/home/ppalex/tmp'; }
use ScriptHelper;

$log->out('START');

#   BannerID    ExportID    GroupExportId   EngineID    BaseNO
open (my $fh, '<', '/home/ppalex/tmp/DIRECT-42261-without_perf_and_dyn_childs-AllBadBanners.tsv') or $log->die($!);

open (my $good, '>', '/home/ppalex/tmp/DIRECT-42261-without_perf_and_dyn_childs-AllBadBanners_detail.tsv') or $log->die($!);
open (my $bad, '>', '/home/ppalex/tmp/DIRECT-42261-without_perf_and_dyn_childs-AllBadBanners_unexist.tsv') or $log->die($!);


my %banners;
sub check {
    my $bids  = shift;

    my $sth = exec_sql(PRODUCTION_PPC_BSHEAVY(shard => 'all'), [
        'SELECT bid, "banner", BannerID FROM banners',
        where => { bid__int => $bids },
        'UNION SELECT image_id, "picture", BannerID FROM banner_images',
        where => { image_id__int => $bids },
        'UNION SELECT mbid, "media", BannerID FROM media_banners',
        where => { mbid__int => $bids },
        'UNION SELECT bid, "deleted", 0 FROM deleted_banners',
        where => { bid__int => $bids },
    ]);
    while (my ($ID, $type, $BannerID) = $sth->fetchrow_array) {
        $banners{$ID}->{type} = $type;
        $banners{$ID}->{BannerID_new} = $BannerID;
    }
    $sth->finish;

    while (my ($ID, $data) = each %banners) {
        if (exists ($data->{type})) {
            print { $good } join ("\t", @{ $data }{ qw/BannerID bid pid EngineID BaseNO type BannerID_new/ } ), "\n";
        } else {
            print { $bad } join ("\t", @{ $data }{ qw/BannerID bid pid EngineID BaseNO/ } ), "\n";
        }
    }
}


my $i = 1;
while (<$fh>) {
    chomp;
    my ($BannerID, $bid, $pid, $EngineID, $BaseNO) = split qr/\t/;
    unless ($BannerID) {
        $log->out("No BannerID!");
        next;
    }
    next unless $bid;
    next unless ($EngineID == 7 || $EngineID == 77);

    $banners{$bid} = {
        bid         => $bid,
        BannerID    => $BannerID,
        pid         => $pid,
        EngineID    => $EngineID,
        BaseNO      => $BaseNO,
    };

    if ($i == 30_000) {
        check([keys %banners]);
        $i = 1;
        %banners = ();
        $log->out("processed row $.");
    } else {
        ++$i;
    }
}

check([keys %banners]);

close ($fh);
close ($good);
close ($bad);

$log->out('FINISH');
